/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public final class DocumentOrderIterator
implements SequenceIterator,
Sortable {
    private SequenceIterator iterator;
    private SequenceExtent sequence;
    private ItemOrderComparer comparer;
    private NodeInfo current = null;
    private int position = 0;

    public DocumentOrderIterator(SequenceIterator base, ItemOrderComparer comparer) throws XPathException {
        this.comparer = comparer;
        this.sequence = new SequenceExtent(base);
        if (this.sequence.getLength() > 1) {
            GenericSorter.quickSort(0, this.sequence.getLength(), this);
        }
        this.iterator = this.sequence.iterate();
    }

    private DocumentOrderIterator() {
    }

    public int compare(int a, int b) {
        return this.comparer.compare((NodeInfo)this.sequence.itemAt(a), (NodeInfo)this.sequence.itemAt(b));
    }

    public void swap(int a, int b) {
        this.sequence.swap(a, b);
    }

    public Item next() throws XPathException {
        NodeInfo next;
        do {
            if ((next = (NodeInfo)this.iterator.next()) != null) continue;
            this.current = null;
            this.position = -1;
            return null;
        } while (this.current != null && next.isSameNodeInfo(this.current));
        ++this.position;
        this.current = next;
        return this.current;
    }

    public int getProperties() {
        return 0;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() throws XPathException {
        DocumentOrderIterator another = new DocumentOrderIterator();
        another.iterator = this.iterator.getAnother();
        return another;
    }
}

