package Evo::GA::Population;

sub new {
	my ($class) = @_;

	my $self = { population => (), };

	$class = ref($class) || $class;

	bless $self, $class;
}

### estimate fitness function
sub fitness_simple {
	my ($self) = shift;
	my $sum = 0.0;

	for (my $i = 0; $i < scalar $self->{population}; $i++) {
		$sum += $self->{population}[$i];
	}

	return ($sum / scalar $self->{population});	
}

sub norm {
	my ($self) = shift;

	my $dotp = 0.0;

	for (my $i = 0; $i < scalar $self->{population}; $i++) {
		$dotp += $self->{population}[$i] * $self->{population}[$i];
	}
	
	return $dotp;
}

1;
