package Net::Amazon::EMR::VolumeSpecification;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'Iops' => ( is => 'ro', 
                isa => 'Int',
           );

has 'SizeInGB' => ( is => 'ro', 
                    isa => 'Int',
                    required => 1,
             );

has 'VolumeType' => ( is => 'ro', 
                      isa => 'Str',
                      required => 1,
                  );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::VolumeSpecification

=head1 DESCRIPTION

Implements the VolumeSpecification data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_VolumeSpecification.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
