# Generated by default/object.tt
package Paws::CloudWatchEvents::ConnectionQueryStringParameter;
  use Moose;
  has IsValueSecret => (is => 'ro', isa => 'Bool');
  has Key => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::ConnectionQueryStringParameter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::ConnectionQueryStringParameter object:

  $service_obj->Method(Att1 => { IsValueSecret => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::ConnectionQueryStringParameter object:

  $result = $service_obj->Method(...);
  $result->Att1->IsValueSecret

=head1 DESCRIPTION

Additional query string parameter for the connection. You can include
up to 100 additional query string parameters per request. Each
additional parameter counts towards the event payload size, which
cannot exceed 64 KB.

=head1 ATTRIBUTES


=head2 IsValueSecret => Bool

Specifies whether the value is secret.


=head2 Key => Str

The key for a query string parameter.


=head2 Value => Str

The value associated with the key for the query string parameter.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

