/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.remote.http.HttpRequest;

public class PredicatedRoute
extends Route<PredicatedRoute> {
    private Function<Injector, CommandHandler> handlerFunc;
    private final Predicate<HttpRequest> predicate;

    PredicatedRoute(Predicate<HttpRequest> predicate) {
        this.predicate = Objects.requireNonNull(predicate);
    }

    public PredicatedRoute using(Class<? extends CommandHandler> handlerClass) {
        Objects.requireNonNull(handlerClass);
        this.handlerFunc = inj -> (CommandHandler)inj.newInstance(handlerClass);
        return this;
    }

    public PredicatedRoute using(CommandHandler handlerInstance) {
        Objects.requireNonNull(handlerInstance);
        this.handlerFunc = inj -> handlerInstance;
        return this;
    }

    @Override
    protected void validate() {
        if (this.handlerFunc == null) {
            throw new IllegalStateException("Handler for route is required");
        }
    }

    @Override
    protected CommandHandler newHandler(Injector injector, HttpRequest request) {
        if (!this.predicate.test(request)) {
            return this.getFallback(injector);
        }
        return this.handlerFunc.apply(injector);
    }
}

