
#############################################################################
## $Id: Scalar.pm 6001 2006-05-02 13:44:59Z spadkins $
#############################################################################

#Transform into hex,compression ????

package App::Serializer::Scalar;
$VERSION = (q$Revision: 6001 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Serializer;
@ISA = ( "App::Serializer" );

use strict;

=head1 NAME

App::Serializer::Scalar - A "serializer" which merely encodes and decodes scalars

=head1 SYNOPSIS

    use App;

    $context = App->context();
    $serializer = $context->service("Serializer");  # or ...
    $serializer = $context->serializer();
    $data = {
        an => 'arbitrary',
        collection => [ 'of', 'data', ],
        of => {
            arbitrary => 'depth',
        },
    };
    $perl = $serializer->serialize($data);
    $data = $serializer->deserialize($perl);
    print $serializer->dump($data), "\n";

=head1 DESCRIPTION

The Scalar serializer encodes (with serialize()) and decodes with (deserialize())
a scalar.  It might be used to encode a binary blob as a hex string and then decode
it agains.

=cut

sub serialize {
    my ($self, $scalar_value) = @_;
    my $encoded_value = $scalar_value;
    if ($self->{pack_format}) {
        $encoded_value = unpack($self->{pack_format}, $encoded_value); #SEB changed pack to unpack
    }
    #print STDERR "(Scalar.pm/serialize) scalar_value=[$scalar_value] pack_format=[$self->{pack_format}] encoded_value=[$encoded_value]\n";
    return($encoded_value);
}

sub deserialize {
    my ($self, $encoded_value) = @_;
    my $scalar_value = $encoded_value;
    if ($self->{pack_format}) {
        $scalar_value = pack($self->{pack_format}, $scalar_value); #SEB changed unpack to pack
    }
    #print STDERR "(Scalar.pm/deserialize) encoded_value=[$encoded_value] pack_format=[$self->{pack_format}] scalar_value=[$scalar_value]\n";
    return($scalar_value);
}

sub serialized_content_type {
    'application/octet-stream';
}

1;

