/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.factory.ElementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementFactoryComplex
implements ElementFactory {
    private final DataSource dataSource;
    private final Collection<ElementFactory> factories = new ArrayList<ElementFactory>();
    private final Dictionary dictionary;

    public AbstractElementFactoryComplex(DataSource dataSource, Dictionary dictionary) {
        this.dataSource = dataSource;
        this.dictionary = dictionary;
    }

    public final void addFactory(ElementFactory elementFactory) {
        this.factories.add(elementFactory);
    }

    protected Terminated<Element> getNextElement() {
        for (ElementFactory elementFactory : this.factories) {
            if (!elementFactory.ready()) continue;
            return elementFactory.create();
        }
        throw new IllegalStateException(this.dataSource.peek(0).getElement());
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    protected final Dictionary getDictionary() {
        return this.dictionary;
    }
}

