use strict;
use warnings;

package App::Embra::Plugin::Cname;
$App::Embra::Plugin::Cname::VERSION = '0.001'; # TRIAL
# ABSTRACT: adds a file containing the site's canonical domain name

use Method::Signatures;

use App::Embra::File;
use Moo;



has 'domain' => (
    is => 'ro',
    required => 1,
);


has 'filename' => (
    is => 'ro',
    default => sub { 'CNAME' },
);

method gather_files {
    $self->add_file( App::Embra::File->new( name => $self->filename, content => $self->domain ) );
}

with 'App::Embra::Role::FileGatherer';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::Cname - adds a file containing the site's canonical domain name

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will add a F<CNAME> file to the site. Use this plugin if you are hosting the site L<on GitHub with a custom domain name|https://help.github.com/articles/setting-up-a-custom-domain-with-pages#setting-the-domain-in-your-repo>.

=head1 ATTRIBUTES

=head2 domain

The canonical domain name for the site (the host part of its URI). This is required.

=head2 filename

The filename to store the site's canonical domain name in. It defaults to F<CNAME>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
