use Test::More tests => 6;

use FindBin;
use lib "$FindBin::Bin/../lib";
use strict;
use warnings;
use Hash::MD5 qw( sum_hash );

my $check_sum1 = Hash::MD5::sum_hash( { string => "This is a test string.", number => 'This is a another string.'});
my $check_sum2 = Hash::MD5::sum_hash( { number => 'This is a another string.', string => "This is a test string."});
ok(('89ea318b49ba024e60bc71ac7a6b1126' eq $check_sum1) == 1, 'test strings');
ok(($check_sum1 eq $check_sum2) == 1, 'test compare strings');


$check_sum1 = Hash::MD5::sum_hash(  { string => 123, number => 321});
$check_sum2 = Hash::MD5::sum_hash(  { number => 321, string => 123});
ok(('623e8d068c5e75a0a123ad2d88ccf23e' eq $check_sum1) == 1, 'test number');
ok(($check_sum1 eq $check_sum2) == 1, 'test compare number');

$check_sum1 = Hash::MD5::sum_hash({ number => 321,string => "This is a test string."});
$check_sum2 = Hash::MD5::sum_hash({ string => "This is a test string.", number => 321});
ok(('8425315a183d200eb61e7959e549ad15' eq $check_sum1) == 1, 'test mixed');
ok(($check_sum1 eq $check_sum2) == 1, 'test compare mixed'); 