package Locales::DB::Language::kk;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::kk::VERSION = '0.09';

$Locales::DB::Language::kk::cldr_version = '2.0';

%Locales::DB::Language::kk::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Тіл\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Аймақ\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\â\\",
        'alternate_quotation_start' => "\â\\",
        'quotation_end'             => "\â\\",
        'quotation_start'           => "\â\\"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "жоқ\:ж",
        'yesstr' => "иә\:и"
    },
);

%Locales::DB::Language::kk::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'Абхаз',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'Африкаан',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => 'амхар',
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => 'Араб',
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => 'ассам',
    'asa'    => 'Asu',
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'Аймара',
    'az'     => 'Азербайжан',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => 'беларус',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => 'болгар',
    'bh'     => 'бихари',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'бенгал',
    'bnt'    => 'Bantu',
    'bo'     => "тибет\ тілі",
    'br'     => 'брит',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'босния',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'каталан',
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'чех',
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => 'валлий',
    'da'     => 'дат',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => "неміс\ тілі",
    'de_at'  => "австриялық неміс\ тілі",
    'de_ch'  => "швейцариялық ұлы\ неміс\ тілі",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'Мальдив',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => "дзонг\-кэ",
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'эфик',
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => 'грек',
    'elx'    => 'Elamite',
    'en'     => "ағылшын\ тілі",
    'en_au'  => "австралиялық ағылшын\ тілі",
    'en_ca'  => "канадалық ағылшын\ тілі",
    'en_gb'  => "британиялық ағылшын\ тілі",
    'en_us'  => "АҚШ\ ағылшын\ тілі",
    'enm'    => "Middle\ English",
    'eo'     => 'эсперанто',
    'es'     => "испан\ тілі",
    'es_419' => "Латин\ Америкалық\ испан\ тілі",
    'es_es'  => "ибериялық испан\ тілі",
    'et'     => 'эстон',
    'eu'     => 'баск',
    'ewo'    => 'Ewondo',
    'fa'     => 'парсы',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'фин',
    'fil'    => 'филиппино',
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => 'Фиджий',
    'fo'     => 'фарер',
    'fon'    => 'Fon',
    'fr'     => "француз\ тілі",
    'fr_ca'  => "канадалық француз\ тілі",
    'fr_ch'  => "швейцариялық француз\ тілі",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => 'Фрис',
    'ga'     => "Ирланд\ тілі",
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "Солтүстік\ Шотландия",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'Гал',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'гуарани',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "Swiss\ German",
    'gu'     => 'гуджарати',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'Хауса',
    'hai'    => 'Haida',
    'haw'    => 'Гавай',
    'he'     => 'иврит',
    'hi'     => 'хинди',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'хорват',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'Гаит',
    'hu'     => 'мадьяр',
    'hup'    => 'Hupa',
    'hy'     => 'армян',
    'hz'     => 'Herero',
    'ia'     => 'интерлингва',
    'iba'    => 'Iban',
    'id'     => 'индонезия',
    'ie'     => 'интерлингве',
    'ig'     => 'Игбо',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'исланд',
    'it'     => "итальян\ тілі",
    'iu'     => 'Inuktitut',
    'ja'     => "жапон\ тілі",
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'ява',
    'ka'     => 'грузин',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => "қазақ\ тілі",
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'камбоджия',
    'kmb'    => 'Kimbundu',
    'kn'     => 'каннада',
    'ko'     => 'кәріс',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Кашмир',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'күрд',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'қырғыз',
    'la'     => 'латын',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Люксембург',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'лингала',
    'lo'     => 'лаос',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'литва',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'латыш',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'малагаси',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'маори',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => 'македон',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'малайялам',
    'mn'     => 'моңғол',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'маратхи',
    'ms'     => 'малай',
    'mt'     => 'мальта',
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'Бирман',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "Norwegian\ Bokm\Ã\¥l",
    'nd'     => "Солтүстік\ ндебел",
    'nds'    => "Low\ German",
    'ne'     => 'непал',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'голланд',
    'nl_be'  => 'флемиш',
    'nmg'    => 'Kwasio',
    'nn'     => "Норвегиялық\ нинорск",
    'no'     => 'норвег',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Солтүстік\ сотхо",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'ньянджа',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'окситан',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'ория',
    'os'     => 'осетин',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'панджаб',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => 'поляк',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'пашто',
    'pt'     => "португал\ тілі",
    'pt_br'  => "бразилиялық\ португал\ тілі",
    'pt_pt'  => "ибериялық\ португал\ тілі",
    'qu'     => 'кечуа',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'ретороман',
    'rn'     => 'рунди',
    'ro'     => 'румын',
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => "орыс\ тілі",
    'rup'    => 'Aromanian',
    'rw'     => 'киньяруанда',
    'rwk'    => 'Rwa',
    'sa'     => 'санскрит',
    'sad'    => 'Sandawe',
    'sah'    => 'якут',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'синдхи',
    'se'     => "Солтүстік\ саам",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'санго',
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => 'сербхорват',
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'сингал',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'словак',
    'sl'     => 'словен',
    'sla'    => "Slavic\ Language",
    'sm'     => 'Samoan',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Shona',
    'snk'    => 'Soninke',
    'so'     => 'сомали',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'албан',
    'sr'     => 'серб',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'Swati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => 'сесото',
    'su'     => 'судан',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => 'швед',
    'sw'     => 'суахили',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'тамил',
    'tai'    => "Tai\ Language",
    'te'     => 'телугу',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Tetum',
    'tg'     => 'Тәжік',
    'th'     => 'тай',
    'ti'     => 'тигринья',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'түркмен',
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalog',
    'tlh'    => 'клингон',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Tswana',
    'to'     => 'Tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "Tok\ Pisin",
    'tr'     => 'Түрік',
    'trv'    => 'Taroko',
    'ts'     => 'Tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tatar',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'тви',
    'twq'    => 'Tasawaq',
    'ty'     => 'Tahitian',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'ұйғыр',
    'uga'    => 'Ugaritic',
    'uk'     => 'украин',
    'umb'    => 'Umbundu',
    'und'    => "белгісіз\ тіл",
    'ur'     => 'урду',
    'uz'     => 'өзбек',
    'vai'    => 'Vai',
    've'     => 'Venda',
    'vi'     => 'вьетнам',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'Wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'хоса',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'идиш',
    'yo'     => 'Иоруба',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => "қытай\ тілі",
    'znd'    => 'Zande',
    'zu'     => 'зулус',
    'zun'    => 'Zuni',
    'zxx'    => "No\ linguistic\ content",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::kk::name_to_code = (
    'achinese'                                         => 'ace',
    'acoli'                                            => 'ach',
    'adangme'                                          => 'ada',
    'adyghe'                                           => 'ady',
    'afar'                                             => 'aa',
    'afrihili'                                         => 'afh',
    'afroasiaticlanguage'                              => 'afa',
    'aghem'                                            => 'agq',
    'ainu'                                             => 'ain',
    'akan'                                             => 'ak',
    'akkadian'                                         => 'akk',
    'aleut'                                            => 'ale',
    'algonquianlanguage'                               => 'alg',
    'altaiclanguage'                                   => 'tut',
    'ancientegyptian'                                  => 'egy',
    'ancientgreek'                                     => 'grc',
    'angika'                                           => 'anp',
    'apachelanguage'                                   => 'apa',
    'aragonese'                                        => 'an',
    'aramaic'                                          => 'arc',
    'arapaho'                                          => 'arp',
    'araucanian'                                       => 'arn',
    'arawak'                                           => 'arw',
    'aromanian'                                        => 'rup',
    'artificiallanguage'                               => 'art',
    'asturian'                                         => 'ast',
    'asu'                                              => 'asa',
    'athapascanlanguage'                               => 'ath',
    'atsam'                                            => 'cch',
    'australianlanguage'                               => 'aus',
    'austronesianlanguage'                             => 'map',
    'avaric'                                           => 'av',
    'avestan'                                          => 'ae',
    'awadhi'                                           => 'awa',
    'bafia'                                            => 'ksf',
    'balinese'                                         => 'ban',
    'balticlanguage'                                   => 'bat',
    'baluchi'                                          => 'bal',
    'bambara'                                          => 'bm',
    'bamilekelanguage'                                 => 'bai',
    'banda'                                            => 'bad',
    'bantu'                                            => 'bnt',
    'basaa'                                            => 'bas',
    'bashkir'                                          => 'ba',
    'batak'                                            => 'btk',
    'beja'                                             => 'bej',
    'bemba'                                            => 'bem',
    'bena'                                             => 'bez',
    'berber'                                           => 'ber',
    'bhojpuri'                                         => 'bho',
    'bikol'                                            => 'bik',
    'bini'                                             => 'bin',
    'bislama'                                          => 'bi',
    'blin'                                             => 'byn',
    'blissymbols'                                      => 'zbl',
    'bodo'                                             => 'brx',
    'braj'                                             => 'bra',
    'buginese'                                         => 'bug',
    'buriat'                                           => 'bua',
    'caddo'                                            => 'cad',
    'cantonese'                                        => 'yue',
    'carib'                                            => 'car',
    'caucasianlanguage'                                => 'cau',
    'cayuga'                                           => 'cay',
    'cebuano'                                          => 'ceb',
    'celticlanguage'                                   => 'cel',
    'centralamericanindianlanguage'                    => 'cai',
    'centralmoroccotamazight'                          => 'tzm',
    'chagatai'                                         => 'chg',
    'chamiclanguage'                                   => 'cmc',
    'chamorro'                                         => 'ch',
    'chechen'                                          => 'ce',
    'cherokee'                                         => 'chr',
    'cheyenne'                                         => 'chy',
    'chibcha'                                          => 'chb',
    'chiga'                                            => 'cgg',
    'chinookjargon'                                    => 'chn',
    'chipewyan'                                        => 'chp',
    'choctaw'                                          => 'cho',
    'churchslavic'                                     => 'cu',
    'chuukese'                                         => 'chk',
    'chuvash'                                          => 'cv',
    'classicalnewari'                                  => 'nwc',
    'classicalsyriac'                                  => 'syc',
    'colognian'                                        => 'ksh',
    'comorian'                                         => 'swb',
    'congoswahili'                                     => 'swc',
    'coptic'                                           => 'cop',
    'cornish'                                          => 'kw',
    'corsican'                                         => 'co',
    'cree'                                             => 'cr',
    'creek'                                            => 'mus',
    'creoleorpidgin'                                   => 'crp',
    'crimeanturkish'                                   => 'crh',
    'cushiticlanguage'                                 => 'cus',
    'dakota'                                           => 'dak',
    'dargwa'                                           => 'dar',
    'dayak'                                            => 'day',
    'delaware'                                         => 'del',
    'dinka'                                            => 'din',
    'dogri'                                            => 'doi',
    'dogrib'                                           => 'dgr',
    'dravidianlanguage'                                => 'dra',
    'duala'                                            => 'dua',
    'dyula'                                            => 'dyu',
    'easternfrisian'                                   => 'frs',
    'ekajuk'                                           => 'eka',
    'elamite'                                          => 'elx',
    'embu'                                             => 'ebu',
    'englishbasedcreoleorpidgin'                       => 'cpe',
    'erzya'                                            => 'myv',
    'ewe'                                              => 'ee',
    'ewondo'                                           => 'ewo',
    'fang'                                             => 'fan',
    'fanti'                                            => 'fat',
    'finnougrianlanguage'                              => 'fiu',
    'fon'                                              => 'fon',
    'frenchbasedcreoleorpidgin'                        => 'cpf',
    'friulian'                                         => 'fur',
    'fulah'                                            => 'ff',
    'ga'                                               => 'gaa',
    'ganda'                                            => 'lg',
    'gayo'                                             => 'gay',
    'gbaya'                                            => 'gba',
    'geez'                                             => 'gez',
    'germaniclanguage'                                 => 'gem',
    'gilbertese'                                       => 'gil',
    'gondi'                                            => 'gon',
    'gorontalo'                                        => 'gor',
    'gothic'                                           => 'got',
    'grebo'                                            => 'grb',
    'gusii'                                            => 'guz',
    "gwich\Ê\¼in"                                    => 'gwi',
    'haida'                                            => 'hai',
    'herero'                                           => 'hz',
    'hiligaynon'                                       => 'hil',
    'himachali'                                        => 'him',
    'hirimotu'                                         => 'ho',
    'hittite'                                          => 'hit',
    'hmong'                                            => 'hmn',
    'hupa'                                             => 'hup',
    'iban'                                             => 'iba',
    'ido'                                              => 'io',
    'ijo'                                              => 'ijo',
    'iloko'                                            => 'ilo',
    'inarisami'                                        => 'smn',
    'indiclanguage'                                    => 'inc',
    'indoeuropeanlanguage'                             => 'ine',
    'ingush'                                           => 'inh',
    'inuktitut'                                        => 'iu',
    'inupiaq'                                          => 'ik',
    'iranianlanguage'                                  => 'ira',
    'iroquoianlanguage'                                => 'iro',
    'jju'                                              => 'kaj',
    'jolafonyi'                                        => 'dyo',
    'judeoarabic'                                      => 'jrb',
    'judeopersian'                                     => 'jpr',
    'kabardian'                                        => 'kbd',
    'kabuverdianu'                                     => 'kea',
    'kabyle'                                           => 'kab',
    'kachin'                                           => 'kac',
    'kalaallisut'                                      => 'kl',
    'kalenjin'                                         => 'kln',
    'kalmyk'                                           => 'xal',
    'kamba'                                            => 'kam',
    'kanuri'                                           => 'kr',
    'karachaybalkar'                                   => 'krc',
    'karakalpak'                                       => 'kaa',
    'karelian'                                         => 'krl',
    'karen'                                            => 'kar',
    'kashubian'                                        => 'csb',
    'kawi'                                             => 'kaw',
    'khasi'                                            => 'kha',
    'khoisanlanguage'                                  => 'khi',
    'khotanese'                                        => 'kho',
    'kikuyu'                                           => 'ki',
    'kimbundu'                                         => 'kmb',
    'komi'                                             => 'kv',
    'kongo'                                            => 'kg',
    'konkani'                                          => 'kok',
    'koro'                                             => 'kfo',
    'kosraean'                                         => 'kos',
    'koyraborosenni'                                   => 'ses',
    'koyrachiini'                                      => 'khq',
    'kpelle'                                           => 'kpe',
    'kru'                                              => 'kro',
    'kuanyama'                                         => 'kj',
    'kumyk'                                            => 'kum',
    'kurukh'                                           => 'kru',
    'kutenai'                                          => 'kut',
    'kwasio'                                           => 'nmg',
    'ladino'                                           => 'lad',
    'lahnda'                                           => 'lah',
    'lamba'                                            => 'lam',
    'langi'                                            => 'lag',
    'lezghian'                                         => 'lez',
    'limburgish'                                       => 'li',
    'lojban'                                           => 'jbo',
    'lowersorbian'                                     => 'dsb',
    'lowgerman'                                        => 'nds',
    'lozi'                                             => 'loz',
    'lubakatanga'                                      => 'lu',
    'lubalulua'                                        => 'lua',
    'luiseno'                                          => 'lui',
    'lulesami'                                         => 'smj',
    'lunda'                                            => 'lun',
    'luo'                                              => 'luo',
    'lushai'                                           => 'lus',
    'luyia'                                            => 'luy',
    'machame'                                          => 'jmc',
    'madurese'                                         => 'mad',
    'magahi'                                           => 'mag',
    'maithili'                                         => 'mai',
    'makasar'                                          => 'mak',
    'makhuwameetto'                                    => 'mgh',
    'makonde'                                          => 'kde',
    'manchu'                                           => 'mnc',
    'mandar'                                           => 'mdr',
    'mandingo'                                         => 'man',
    'manipuri'                                         => 'mni',
    'manobolanguage'                                   => 'mno',
    'manx'                                             => 'gv',
    'mari'                                             => 'chm',
    'marshallese'                                      => 'mh',
    'marwari'                                          => 'mwr',
    'masai'                                            => 'mas',
    'mayanlanguage'                                    => 'myn',
    'mende'                                            => 'men',
    'meru'                                             => 'mer',
    'micmac'                                           => 'mic',
    'middledutch'                                      => 'dum',
    'middleenglish'                                    => 'enm',
    'middlefrench'                                     => 'frm',
    'middlehighgerman'                                 => 'gmh',
    'middleirish'                                      => 'mga',
    'minangkabau'                                      => 'min',
    'mirandese'                                        => 'mwl',
    'miscellaneouslanguage'                            => 'mis',
    'mohawk'                                           => 'moh',
    'moksha'                                           => 'mdf',
    'moldavian'                                        => 'mo',
    'mongo'                                            => 'lol',
    'monkhmerlanguage'                                 => 'mkh',
    'morisyen'                                         => 'mfe',
    'mossi'                                            => 'mos',
    'multiplelanguages'                                => 'mul',
    'mundalanguage'                                    => 'mun',
    'mundang'                                          => 'mua',
    'nahuatl'                                          => 'nah',
    'nama'                                             => 'naq',
    'nauru'                                            => 'na',
    'navajo'                                           => 'nv',
    'ndonga'                                           => 'ng',
    'neapolitan'                                       => 'nap',
    'newari'                                           => 'new',
    'nias'                                             => 'nia',
    'nigerkordofanianlanguage'                         => 'nic',
    'nilosaharanlanguage'                              => 'ssa',
    'niuean'                                           => 'niu',
    'nogai'                                            => 'nog',
    'nolinguisticcontent'                              => 'zxx',
    'northamericanindianlanguage'                      => 'nai',
    'northernfrisian'                                  => 'frr',
    "norwegianbokm\Ã\¥l"                             => 'nb',
    'nubianlanguage'                                   => 'nub',
    'nuer'                                             => 'nus',
    'nyamwezi'                                         => 'nym',
    'nyankole'                                         => 'nyn',
    'nyasatonga'                                       => 'tog',
    'nyoro'                                            => 'nyo',
    'nzima'                                            => 'nzi',
    "n\â\\ko"                                     => 'nqo',
    'ojibwa'                                           => 'oj',
    'oldenglish'                                       => 'ang',
    'oldfrench'                                        => 'fro',
    'oldhighgerman'                                    => 'goh',
    'oldirish'                                         => 'sga',
    'oldnorse'                                         => 'non',
    'oldpersian'                                       => 'peo',
    "oldproven\Ã\§al"                                => 'pro',
    'oromo'                                            => 'om',
    'osage'                                            => 'osa',
    'otomianlanguage'                                  => 'oto',
    'ottomanturkish'                                   => 'ota',
    'pahlavi'                                          => 'pal',
    'palauan'                                          => 'pau',
    'pali'                                             => 'pi',
    'pampanga'                                         => 'pam',
    'pangasinan'                                       => 'pag',
    'papiamento'                                       => 'pap',
    'papuanlanguage'                                   => 'paa',
    'philippinelanguage'                               => 'phi',
    'phoenician'                                       => 'phn',
    'pohnpeian'                                        => 'pon',
    'portuguesebasedcreoleorpidgin'                    => 'cpp',
    'prakritlanguage'                                  => 'pra',
    'rajasthani'                                       => 'raj',
    'rapanui'                                          => 'rap',
    'rarotongan'                                       => 'rar',
    'romancelanguage'                                  => 'roa',
    'romany'                                           => 'rom',
    'rombo'                                            => 'rof',
    'rwa'                                              => 'rwk',
    'saho'                                             => 'ssy',
    'salishanlanguage'                                 => 'sal',
    'samaritanaramaic'                                 => 'sam',
    'samburu'                                          => 'saq',
    'samilanguage'                                     => 'smi',
    'samoan'                                           => 'sm',
    'sandawe'                                          => 'sad',
    'sangu'                                            => 'sbp',
    'santali'                                          => 'sat',
    'sardinian'                                        => 'sc',
    'sasak'                                            => 'sas',
    'scots'                                            => 'sco',
    'selkup'                                           => 'sel',
    'semiticlanguage'                                  => 'sem',
    'sena'                                             => 'seh',
    'seneca'                                           => 'see',
    'serer'                                            => 'srr',
    'shambala'                                         => 'ksb',
    'shan'                                             => 'shn',
    'shona'                                            => 'sn',
    'sichuanyi'                                        => 'ii',
    'sicilian'                                         => 'scn',
    'sidamo'                                           => 'sid',
    'signlanguage'                                     => 'sgn',
    'siksika'                                          => 'bla',
    'sinotibetanlanguage'                              => 'sit',
    'siouanlanguage'                                   => 'sio',
    'skoltsami'                                        => 'sms',
    'slave'                                            => 'den',
    'slaviclanguage'                                   => 'sla',
    'soga'                                             => 'xog',
    'sogdien'                                          => 'sog',
    'songhai'                                          => 'son',
    'soninke'                                          => 'snk',
    'sorbianlanguage'                                  => 'wen',
    'southamericanindianlanguage'                      => 'sai',
    'southernaltai'                                    => 'alt',
    'southernsami'                                     => 'sma',
    'southndebele'                                     => 'nr',
    'sranantongo'                                      => 'srn',
    'sukuma'                                           => 'suk',
    'sumerian'                                         => 'sux',
    'susu'                                             => 'sus',
    'swati'                                            => 'ss',
    'swissgerman'                                      => 'gsw',
    'syriac'                                           => 'syr',
    'tachelhit'                                        => 'shi',
    'tagalog'                                          => 'tl',
    'tahitian'                                         => 'ty',
    'tailanguage'                                      => 'tai',
    'taita'                                            => 'dav',
    'tamashek'                                         => 'tmh',
    'taroko'                                           => 'trv',
    'tasawaq'                                          => 'twq',
    'tatar'                                            => 'tt',
    'tereno'                                           => 'ter',
    'teso'                                             => 'teo',
    'tetum'                                            => 'tet',
    'tigre'                                            => 'tig',
    'timne'                                            => 'tem',
    'tiv'                                              => 'tiv',
    'tlingit'                                          => 'tli',
    'tokelau'                                          => 'tkl',
    'tokpisin'                                         => 'tpi',
    'tonga'                                            => 'to',
    'tsimshian'                                        => 'tsi',
    'tsonga'                                           => 'ts',
    'tswana'                                           => 'tn',
    'tumbuka'                                          => 'tum',
    'tupilanguage'                                     => 'tup',
    'tuvalu'                                           => 'tvl',
    'tuvinian'                                         => 'tyv',
    'tyap'                                             => 'kcg',
    'udmurt'                                           => 'udm',
    'ugaritic'                                         => 'uga',
    'umbundu'                                          => 'umb',
    'uppersorbian'                                     => 'hsb',
    'vai'                                              => 'vai',
    'venda'                                            => 've',
    "volap\Ã\¼k"                                     => 'vo',
    'votic'                                            => 'vot',
    'vunjo'                                            => 'vun',
    'wakashanlanguage'                                 => 'wak',
    'walamo'                                           => 'wal',
    'walloon'                                          => 'wa',
    'walser'                                           => 'wae',
    'waray'                                            => 'war',
    'washo'                                            => 'was',
    'wolof'                                            => 'wo',
    'yangben'                                          => 'yav',
    'yao'                                              => 'yao',
    'yapese'                                           => 'yap',
    'yupiklanguage'                                    => 'ypk',
    'zande'                                            => 'znd',
    'zapotec'                                          => 'zap',
    'zarma'                                            => 'dje',
    'zaza'                                             => 'zza',
    'zenaga'                                           => 'zen',
    'zhuang'                                           => 'za',
    'zuni'                                             => 'zun',
    'Абхаз'                                       => 'ab',
    'Азербайжан'                             => 'az',
    'Аймара'                                     => 'ay',
    'Араб'                                         => 'ar',
    'Африкаан'                                 => 'af',
    'АҚШағылшынтілі'                     => 'en_us',
    'Бирман'                                     => 'my',
    'Гавай'                                       => 'haw',
    'Гаит'                                         => 'ht',
    'Гал'                                           => 'gl',
    'Игбо'                                         => 'ig',
    'Иоруба'                                     => 'yo',
    'Ирландтілі'                             => 'ga',
    'Кашмир'                                     => 'ks',
    'ЛатинАмерикалықиспантілі' => 'es_419',
    'Люксембург'                             => 'lb',
    'Мальдив'                                   => 'dv',
    'Норвегиялықнинорск'             => 'nn',
    'СолтүстікШотландия'             => 'gd',
    'Солтүстікндебел'                   => 'nd',
    'Солтүстіксаам'                       => 'se',
    'Солтүстіксотхо'                     => 'nso',
    'Түрік'                                       => 'tr',
    'Тәжік'                                       => 'tg',
    'Фиджий'                                     => 'fj',
    'Фрис'                                         => 'fy',
    'Хауса'                                       => 'ha',
    'австралиялықағылшынтілі'   => 'en_au',
    'австриялықнемістілі'           => 'de_at',
    'албан'                                       => 'sq',
    'амхар'                                       => 'am',
    'армян'                                       => 'hy',
    'ассам'                                       => 'as',
    'ағылшынтілі'                           => 'en',
    'баск'                                         => 'eu',
    'беларус'                                   => 'be',
    'белгісізтіл'                           => 'und',
    'бенгал'                                     => 'bn',
    'бихари'                                     => 'bh',
    'болгар'                                     => 'bg',
    'босния'                                     => 'bs',
    'бразилиялықпортугалтілі'   => 'pt_br',
    'брит'                                         => 'br',
    'британиялықағылшынтілі'     => 'en_gb',
    'валлий'                                     => 'cy',
    'вьетнам'                                   => 'vi',
    'голланд'                                   => 'nl',
    'грек'                                         => 'el',
    'грузин'                                     => 'ka',
    'гуарани'                                   => 'gn',
    'гуджарати'                               => 'gu',
    'дат'                                           => 'da',
    'дзонгкэ'                                   => 'dz',
    'жапонтілі'                               => 'ja',
    'зулус'                                       => 'zu',
    'ибериялықиспантілі'             => 'es_es',
    'ибериялықпортугалтілі'       => 'pt_pt',
    'иврит'                                       => 'he',
    'идиш'                                         => 'yi',
    'индонезия'                               => 'id',
    'интерлингва'                           => 'ia',
    'интерлингве'                           => 'ie',
    'исланд'                                     => 'is',
    'испантілі'                               => 'es',
    'итальянтілі'                           => 'it',
    'камбоджия'                               => 'km',
    'канадалықағылшынтілі'         => 'en_ca',
    'канадалықфранцузтілі'         => 'fr_ca',
    'каннада'                                   => 'kn',
    'каталан'                                   => 'ca',
    'кечуа'                                       => 'qu',
    'киньяруанда'                           => 'rw',
    'клингон'                                   => 'tlh',
    'күрд'                                         => 'ku',
    'кәріс'                                       => 'ko',
    'лаос'                                         => 'lo',
    'латын'                                       => 'la',
    'латыш'                                       => 'lv',
    'лингала'                                   => 'ln',
    'литва'                                       => 'lt',
    'мадьяр'                                     => 'hu',
    'македон'                                   => 'mk',
    'малагаси'                                 => 'mg',
    'малай'                                       => 'ms',
    'малайялам'                               => 'ml',
    'мальта'                                     => 'mt',
    'маори'                                       => 'mi',
    'маратхи'                                   => 'mr',
    'моңғол'                                     => 'mn',
    'немістілі'                               => 'de',
    'непал'                                       => 'ne',
    'норвег'                                     => 'no',
    'ньянджа'                                   => 'ny',
    'окситан'                                   => 'oc',
    'ория'                                         => 'or',
    'орыстілі'                                 => 'ru',
    'осетин'                                     => 'os',
    'панджаб'                                   => 'pa',
    'парсы'                                       => 'fa',
    'пашто'                                       => 'ps',
    'поляк'                                       => 'pl',
    'португалтілі'                         => 'pt',
    'ретороман'                               => 'rm',
    'румын'                                       => 'ro',
    'рунди'                                       => 'rn',
    'санго'                                       => 'sg',
    'санскрит'                                 => 'sa',
    'серб'                                         => 'sr',
    'сербхорват'                             => 'sh',
    'сесото'                                     => 'st',
    'сингал'                                     => 'si',
    'синдхи'                                     => 'sd',
    'словак'                                     => 'sk',
    'словен'                                     => 'sl',
    'сомали'                                     => 'so',
    'суахили'                                   => 'sw',
    'судан'                                       => 'su',
    'тай'                                           => 'th',
    'тамил'                                       => 'ta',
    'тви'                                           => 'tw',
    'телугу'                                     => 'te',
    'тибеттілі'                               => 'bo',
    'тигринья'                                 => 'ti',
    'түркмен'                                   => 'tk',
    'украин'                                     => 'uk',
    'урду'                                         => 'ur',
    'фарер'                                       => 'fo',
    'филиппино'                               => 'fil',
    'фин'                                           => 'fi',
    'флемиш'                                     => 'nl_be',
    'французтілі'                           => 'fr',
    'хинди'                                       => 'hi',
    'хорват'                                     => 'hr',
    'хоса'                                         => 'xh',
    'чех'                                           => 'cs',
    'швед'                                         => 'sv',
    'швейцариялықфранцузтілі'   => 'fr_ch',
    'швейцариялықұлынемістілі' => 'de_ch',
    'эсперанто'                               => 'eo',
    'эстон'                                       => 'et',
    'эфик'                                         => 'efi',
    'ява'                                           => 'jv',
    'якут'                                         => 'sah',
    'қазақтілі'                               => 'kk',
    'қырғыз'                                     => 'ky',
    'қытайтілі'                               => 'zh',
    'ұйғыр'                                       => 'ug',
    'өзбек'                                       => 'uz',
);

1;
