# Generated by default/object.tt
package Paws::CostExplorer::CostCategoryInheritedValueDimension;
  use Moose;
  has DimensionKey => (is => 'ro', isa => 'Str');
  has DimensionName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::CostCategoryInheritedValueDimension

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::CostCategoryInheritedValueDimension object:

  $service_obj->Method(Att1 => { DimensionKey => $value, ..., DimensionName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::CostCategoryInheritedValueDimension object:

  $result = $service_obj->Method(...);
  $result->Att1->DimensionKey

=head1 DESCRIPTION

When creating or updating a cost category, you can define the
C<CostCategoryRule> rule type as C<INHERITED_VALUE>. This rule type
adds the flexibility of defining a rule that dynamically inherits the
cost category value from the dimension value defined by
C<CostCategoryInheritedValueDimension>. For example, if you wanted to
dynamically group costs based on the value of a specific tag key, you
would first choose an inherited value rule type, then choose the tag
dimension and specify the tag key to use.

=head1 ATTRIBUTES


=head2 DimensionKey => Str

The key to extract cost category values.


=head2 DimensionName => Str

The name of dimension for which to group costs.

If you specify C<LINKED_ACCOUNT_NAME>, the cost category value will be
based on account name. If you specify C<TAG>, the cost category value
will be based on the value of the specified tag key.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

