package Bundle::Atoll;

use 5.008008;
use strict;
use warnings;

our $VERSION = '0.01';

1;
__END__

=head1 NAME

Bundle::Atoll - Perl extension for ATOLL Linguistic Processing Chain

=head1 SYNOPSIS

  use Bundle::Atoll;

  C<perl -MCPAN -e 'install Bundle::ATOLL'>

=head1 DESCRIPTION

This bundle regroups all Perl modules needed to install and run 
ATOLL Linguistic Processing chain.

=head2 EXPORT

None by default.

=head1 CONTENTS

Algorithm::Diff    - Compute 'intelligent' differences between two files / lists 
AppConfig          - Reading configuration files and parsing command line arguments 
CGI                - Simple Common Gateway Interface Class 
Class::Generate    - Generate Perl class hierarchies 
Clone              - Recursive copy of nested objects 
DBI                - Database independent interface for Perl 
Data::Compare      - Compare perl data structures 
Data::Dumper       - Convert data structure into perl code 
Data::Grove        - Support for deeply nested structures 
DateTime           - A complete, easy to use date and time object 
Encode             - Character Encodings Handler 
Event              - Fast, generic event loop 
ExtUtils::configPL - Configures .PL files 
File::Basename     - Return basename of a filename 
File::Temp         - Create temporary files safely 
FindBin            - Locate current script bin directory 
Getopt::Long       - Advanced handling of command line options 
Getopt::Mixed      - Supports both long and short options 
IO::All
IO::Handle         - Base class for input/output handles 
IO::Pipe           - Methods for pipe handles 
IO::Pty            - Pseudo TTY object class 
IO::Select         - Object interface to system select call 
IO::Socket         - Methods for socket input/output handles 
IPC::Open2         - Open a process for both reading and writing 
IPC::Open3         - Like IPC::Open2 but with error handling 
IPC::Run           - Child procs w/ piping, redir and psuedo-ttys 
List::Compare      - Compare elements of two or more lists 
List::MoreUtils    - Provide the stuff missing in List::Util 
List::Util         - List utilities (eg min, max, reduce) 
Net::Server        - Extensible (class) oriented internet server 
Net::Telnet        - Interact with TELNET port or other TCP ports 
Parse::RecDescent  - Recursive descent parser generator 
Parse::Yapp        - Generates OO LALR parser modules 
Regexp::Assemble   - Combine patterns into single pattern 
Term::Report       - Easy way to create dynamic 'reports' from within scripts 
Test::Cmd          - Portable test infrastructure for commands 
Tie::IxHash        - Indexed hash (ordered array/hash composite) 
Time::HiRes        - High resolution time, sleep, and alarm 
XML::Generator     - Generates XML documents 
XML::LibXML        - Interface to the libxml library 
XML::Parser        - Flexible fast parser with plug-in styles 
XML::Twig          - A module for easy processing of XML 
XSLoader           - Dynamically load C libraries into Perl code 

=head1 SEE ALSO

Check web page of ATOLL Linguistic Processing Chain for information: 
L<http://atoll.inria.fr/installatoll.en.html>

=head1 AUTHOR

Isabelle Cabrera, E<lt>Isabelle.Cabrera@inria.frE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007, INRIA

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.

=cut
