# Tomtit

Tomtit - Perl6 task runner with dozens of [plugins](https://github.com/melezhik/sparrowdo).

![tomtit example output](https://raw.githubusercontent.com/melezhik/tomtit/master/tomtit-output.png)

[![Build Status](https://travis-ci.org/melezhik/tomtit.svg?branch=master)](https://travis-ci.org/melezhik/tomtit)

# INSTALL

    zef install Tomtit

# Bootstrap

You need to bootstrap your system to start using tomtit, it's a one time operation,
where you install Sparrow which is underlying tomtit runner.
    
    tom --bootstrap 

# USAGE

    tom $action|$options $thing

Run scenario:

    tom $scenario

Default action (list of scenarios):

    tom

List available scenarios:

    tom --list

Get help:

    tom --help

Show the last executed scenario:

    tom --last

Clean tomtit cache:

    tom --clean

Example:

    tom --list

    [scenarios list]
    test
    build
    install

    tom test        

# Defining scenarios

Tomtit scenarios are just Sparrowdo scenarios you create in `.tom` directory,
which is base Tomtit directory:
  
    mkdir .tom/
    nano .tom/build.pl6
    nano .tom/test.pl6
    nano .tom/install.pl6

You want to ignore tomtit cache which commit files to SCM:

    git add .tom/
    echo .tom/.cache >> .gitignore


# Scenario example

You can do anything, allowable through [Sparrowdo API](https://github.com/melezhik/sparrowdo), like:

    cat .tom/example.pl6

    # you can Sparrowdo shortcuts 
    # to create files and directories

    file 'passwords.txt', %( content => "super secret" );

    directory '.cache';

    # or restart service

    service-restart "web-app";

    # or you can run a certain sparrow plugin
    # by using task-run function:

    task-run 'my task', 'plugin', %( foo => 'bar' );

    # for example, to set git repository, 
    # use git-base plugin:
 
    task-run "set git", "git-base", %(
      email => 'melezhik@gmail.com',
      name  => 'Alexey Melezhik',
      config_scope => 'local',
      set_credential_cache => 'on'
    );

    
And so on.

As result you minimize code to execute many typical tasks.


# Profiles

Profiles are predefined sets of Tomtit scenarios.
To start using scenarios from profile you say:

    tom --profile $profile

Once the command is executed the profile's scenarios get installed to the
base Tomtit directory.

To list available profiles say this:

    tom --profile

To list profiles scenarios say this:

    tom --list --profile $profile

# Removing scenarios

To remove installed scenario say this:

    tom --remove $scenario

# Options

    --verbose   # run scenario in verbose mode
    --quiet,-q  # run scenario in less verbose mode

# Author

Alexey Melezhik


# Thanks to

God Who gives me inspiration in my work

