# Generated by default/object.tt
package Paws::NimbleStudio::StreamingImage;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Ec2ImageId => (is => 'ro', isa => 'Str', request_name => 'ec2ImageId', traits => ['NameInRequest']);
  has EncryptionConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::StreamingImageEncryptionConfiguration', request_name => 'encryptionConfiguration', traits => ['NameInRequest']);
  has EulaIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'eulaIds', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Owner => (is => 'ro', isa => 'Str', request_name => 'owner', traits => ['NameInRequest']);
  has Platform => (is => 'ro', isa => 'Str', request_name => 'platform', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has StatusCode => (is => 'ro', isa => 'Str', request_name => 'statusCode', traits => ['NameInRequest']);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has StreamingImageId => (is => 'ro', isa => 'Str', request_name => 'streamingImageId', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::NimbleStudio::Tags', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::StreamingImage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::StreamingImage object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::StreamingImage object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the resource.


=head2 Description => Str

A human-readable description of the streaming image.


=head2 Ec2ImageId => Str

The ID of an EC2 machine image with which to create the streaming
image.


=head2 EncryptionConfiguration => L<Paws::NimbleStudio::StreamingImageEncryptionConfiguration>

The encryption configuration.


=head2 EulaIds => ArrayRef[Str|Undef]

The list of EULAs that must be accepted before a Streaming Session can
be started using this streaming image.


=head2 Name => Str

A friendly name for a streaming image resource.


=head2 Owner => Str

The owner of the streaming image, either the studioId that contains the
streaming image, or 'amazon' for images that are provided by Amazon
Nimble Studio.


=head2 Platform => Str

The platform of the streaming image, either WINDOWS or LINUX.


=head2 State => Str

The current state.


=head2 StatusCode => Str

The status code.


=head2 StatusMessage => Str

The status message for the streaming image.


=head2 StreamingImageId => Str

The ID of the streaming image.


=head2 Tags => L<Paws::NimbleStudio::Tags>

A collection of labels, in the form of key:value pairs, that apply to
this resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

