# Generated by default/object.tt
package Paws::IoTEvents::AcknowledgeFlow;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool', request_name => 'enabled', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::AcknowledgeFlow

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::AcknowledgeFlow object:

  $service_obj->Method(Att1 => { Enabled => $value, ..., Enabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::AcknowledgeFlow object:

  $result = $service_obj->Method(...);
  $result->Att1->Enabled

=head1 DESCRIPTION

Specifies whether to get notified for alarm state changes.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Enabled => Bool

The value must be C<TRUE> or C<FALSE>. If C<TRUE>, you receive a
notification when the alarm state changes. You must choose to
acknowledge the notification before the alarm state can return to
C<NORMAL>. If C<FALSE>, you won't receive notifications. The alarm
automatically changes to the C<NORMAL> state when the input property
value returns to the specified range.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

