use Chart::Plotly;
use Chart::Plotly::Trace::Streamtube;
use Chart::Plotly::Plot;

# Example from https://github.com/plotly/plotly.js/blob/273292dcb24170f775dbc7ebb285c9b6a80b10f4/test/image/mocks/gl3d_streamtube-simple.json

my $trace = Chart::Plotly::Trace::Streamtube->new(
    cmax    => 3,
    cmin    => 0,
    sizeref => 0.5,
    type    => 'streamtube',
    u       => [ (1) x 9, (1.8414709848079) x 9, (1.90929742682568) x 9 ],
    v       => [
           (1) x 3,
           (0.54030230586814) x 3,
           (-0.416146836547142) x 3,
           (1) x 3,
           (0.54030230586814) x 3,
           (-0.416146836547142) x 3,
           (1) x 3,
           (0.54030230586814) x 3,
           (-0.416146836547142) x 3
    ],
    w => [ 0,                  0.0886560619984019, 0.169392742018511,  0,
           0.0886560619984019, 0.169392742018511,  0,                  0.0886560619984019,
           0.169392742018511,  0,                  0.0886560619984019, 0.169392742018511,
           0,                  0.0886560619984019, 0.169392742018511,  0,
           0.0886560619984019, 0.169392742018511,  0,                  0.0886560619984019,
           0.169392742018511,  0,                  0.0886560619984019, 0.169392742018511,
           0,                  0.0886560619984019, 0.169392742018511
    ],
    x => [ (0) x 9, (1) x 9, (2) x 9 ],
    y => [ (0) x 3, (1) x 3, (2) x 3, (0) x 3, (1) x 3, (2) x 3, (0) x 3, (1) x 3, (2) x 3 ],
    z => [ 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2 ]

);

my $plot = Chart::Plotly::Plot->new( traces => [$trace],
                                     layout => {
                                                 scene => {
                                                            camera => {
                                                                        eye => { x => -0.724361245886518,
                                                                                 y => 1.9269804254718,
                                                                                 z => 0.670482829986172
                                                                        }
                                                            }
                                                 }
                                     }
);

Chart::Plotly::show_plot($plot);

