[![Actions Status](https://github.com/sanko/Acme-ICan-tBelieveItCanSort/actions/workflows/linux.yml/badge.svg)](https://github.com/sanko/Acme-ICan-tBelieveItCanSort/actions) [![Actions Status](https://github.com/sanko/Acme-ICan-tBelieveItCanSort/actions/workflows/windows.yml/badge.svg)](https://github.com/sanko/Acme-ICan-tBelieveItCanSort/actions) [![Actions Status](https://github.com/sanko/Acme-ICan-tBelieveItCanSort/actions/workflows/macos.yml/badge.svg)](https://github.com/sanko/Acme-ICan-tBelieveItCanSort/actions) [![MetaCPAN Release](https://badge.fury.io/pl/Acme-ICan-tBelieveItCanSort.svg)](https://metacpan.org/release/Acme-ICan-tBelieveItCanSort)
# NAME

Acme::ICan'tBelieveItCanSort - Wait... It Actually Works?

# SYNOPSIS

    use Acme::ICan'tBelieveItCanSort;
        Acme::ICan'tBelieveItCanSort( 3, 4, 5, 5, 68, 1, 4, 321, 32, 321 );

# DESCRIPTION

Acme::ICan'tBelieveItCanSort is a pure Perl implementation of "the simplest
(and most surprising) sorting algorithm ever" as described by Stanley P. Y.
Fung:

    We present an extremely simple sorting algorithm. It may look like it is
    obviously wrong, but we prove that it is in fact correct. We compare it with
    other simple sorting algorithms, and analyse some of its curious properties.

This module itself is named after [`Algorithm
1`](https://arxiv.org/pdf/2110.01111.pdf).

# See Also

- "Is this the simplest (and most surprising) sorting algorithm ever?"

    Stanley P. Y. Fung, https://arxiv.org/abs/2110.01111

- https://github.com/mattn/i\_cant\_believe\_it\_can
- https://github.com/theshteves/simplest-sort
- https://github.com/PCBoyGames/ArrayV-v4.0/blob/main/src/sorts/exchange/UnbelievableSort.java
- https://github.com/jefflunt/unbelievable-sort

# LICENSE

Copyright (C) Sanko Robinson.

This library is free software; you can redistribute it and/or modify it under
the terms found in the Artistic License 2. Other copyrights, terms, and
conditions may apply to data transmitted through this module.

# AUTHOR

Sanko Robinson <sanko@cpan.org>
