package Google::Ads::AdWords::v201809::OfflineConversionAdjustmentFeed;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %conversionName_of :ATTR(:get<conversionName>);
my %adjustmentTime_of :ATTR(:get<adjustmentTime>);
my %adjustmentType_of :ATTR(:get<adjustmentType>);
my %adjustedValue_of :ATTR(:get<adjustedValue>);
my %adjustedValueCurrencyCode_of :ATTR(:get<adjustedValueCurrencyCode>);
my %OfflineConversionAdjustmentFeed__Type_of :ATTR(:get<OfflineConversionAdjustmentFeed__Type>);

__PACKAGE__->_factory(
    [ qw(        conversionName
        adjustmentTime
        adjustmentType
        adjustedValue
        adjustedValueCurrencyCode
        OfflineConversionAdjustmentFeed__Type

    ) ],
    {
        'conversionName' => \%conversionName_of,
        'adjustmentTime' => \%adjustmentTime_of,
        'adjustmentType' => \%adjustmentType_of,
        'adjustedValue' => \%adjustedValue_of,
        'adjustedValueCurrencyCode' => \%adjustedValueCurrencyCode_of,
        'OfflineConversionAdjustmentFeed__Type' => \%OfflineConversionAdjustmentFeed__Type_of,
    },
    {
        'conversionName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'adjustmentTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'adjustmentType' => 'Google::Ads::AdWords::v201809::OfflineConversionAdjustmentType',
        'adjustedValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'adjustedValueCurrencyCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'OfflineConversionAdjustmentFeed__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'conversionName' => 'conversionName',
        'adjustmentTime' => 'adjustmentTime',
        'adjustmentType' => 'adjustmentType',
        'adjustedValue' => 'adjustedValue',
        'adjustedValueCurrencyCode' => 'adjustedValueCurrencyCode',
        'OfflineConversionAdjustmentFeed__Type' => 'OfflineConversionAdjustmentFeed.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::OfflineConversionAdjustmentFeed

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OfflineConversionAdjustmentFeed from the namespace https://adwords.google.com/api/adwords/cm/v201809.

Represents a record in the offline conversion adjustments feed that advertisers upload. This class is inherited by GclidOfflineConversionAdjustmentFeed and OrderIdOfflineConversionAdjustmentFeed because advertisers upload conversion name and either (order id) or (gclid, conversion time) to identify a conversion. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * conversionName


=item * adjustmentTime


=item * adjustmentType


=item * adjustedValue


=item * adjustedValueCurrencyCode


=item * OfflineConversionAdjustmentFeed__Type

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 OfflineConversionAdjustmentFeed.Type




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

