use utf8;

package SemanticWeb::Schema::OfferForLease;

# ABSTRACT: An [[OfferForLease]] in Schema

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::Offer /;


use MooX::JSON_LD 'OfferForLease';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v23.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::OfferForLease - An [[OfferForLease]] in Schema

=head1 VERSION

version v23.0.0

=head1 DESCRIPTION

An L<SemanticWeb::Schema::OfferForLease> in Schema.org represents an L<SemanticWeb::Schema::Offer> to lease out something, i.e. an L<SemanticWeb::Schema::Offer> whose
  [[businessFunction]] is L<lease out|http://purl.org/goodrelations/v1#LeaseOut.>. See L<Good Relations|https://en.wikipedia.org/wiki/GoodRelations> for
  background on the underlying concepts.

=head1 SEE ALSO

L<SemanticWeb::Schema::Offer>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
