# Generated by default/object.tt
package Paws::ImageBuilder::LaunchTemplateConfiguration;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has LaunchTemplateId => (is => 'ro', isa => 'Str', request_name => 'launchTemplateId', traits => ['NameInRequest'], required => 1);
  has SetDefaultVersion => (is => 'ro', isa => 'Bool', request_name => 'setDefaultVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::LaunchTemplateConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::LaunchTemplateConfiguration object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., SetDefaultVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::LaunchTemplateConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Identifies an Amazon EC2 launch template to use for a specific account.

=head1 ATTRIBUTES


=head2 AccountId => Str

The account ID that this configuration applies to.


=head2 B<REQUIRED> LaunchTemplateId => Str

Identifies the Amazon EC2 launch template to use.


=head2 SetDefaultVersion => Bool

Set the specified Amazon EC2 launch template as the default launch
template for the specified account.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

