# Generated by default/object.tt
package Paws::AuditManager::AssessmentFramework;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ControlSets => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::AssessmentControlSet]', request_name => 'controlSets', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Metadata => (is => 'ro', isa => 'Paws::AuditManager::FrameworkMetadata', request_name => 'metadata', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::AssessmentFramework

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::AssessmentFramework object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Metadata => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::AssessmentFramework object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The file used to structure and automate AWS Audit Manager assessments
for a given compliance standard.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the specified framework.


=head2 ControlSets => ArrayRef[L<Paws::AuditManager::AssessmentControlSet>]

The control sets associated with the framework.


=head2 Id => Str

The unique identifier for the framework.


=head2 Metadata => L<Paws::AuditManager::FrameworkMetadata>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

