#! /usr/bin/perl

use strict;
use warnings;

use lib qw(../lib);
use CGI qw(escapeHTML);
use Lingua::JA::Summarize;


my $q = new CGI;

print $q->header(-charset => 'euc-jp');

my $text = $q->param('txt') || '';
if ($text) {
    print "Keywords: ";
    my $s = Lingua::JA::Summarize->new;
    $s->analyze($text);
    print join(' ', $s->keywords({
	maxwords => $q->param('maxwords') || 5,
	threshold => $q->param('threshold') || 5,
    }));
} else {
    $text = << "EOT";
 ƻϩ̻ΡʿͿȻΤ˸¤롣ʲܹˤƱˤĹŪܤߤȡ塢£ǯȾ飴ǯȾФޤǤϡԿ礷Ƥꡢǯ飴ǯޤǤ˻Կϣͤ飹ͤءԿϣͤ飱ͤؤäƤ롣
ϡּҲ񲽤ε®ʿŸФơƻϩ浡ƻϩɸθ̰ߤ­ƤȤϤȤꡢξΰݤ뤿εѤ̤ȯãǤäȤ䡢̼ҲѲФ͡ΰռ٤ƤȤʤɡҲʬäƤʤäȤװǤäȹͤ뤳ȤǤ롣
Τᡢ̰γݤϾμҲȤʤꡢ£ǯ˸̰кˡʾˡˤꤵ졢󤲤Ƥθ̰кʤ줿
ƱˡǤϡ̤ΰ˴ؤŪĹŪʻܺˤǤ̰ܷײκˤĤƤꡢ£ǯ٤裱̰ܷײ褫Ϥޤꡢߤʿǯ٤飱ǯ٤ޤǤΣǯ֤ײ֤Ȥ裷̰ܷײ褬»ܤƤ롣ƷײǤϡ줾ã٤ɸǤ̰˴ؤܺϤ˿ʤƤη̡ǯθ̻λԿϣͤȤʤꡢǯ򹹤˲ꣷȾޤǸ˻ä裱ɽˡ
ԿˤĤƤϡ裱ڤ裲̰ܷײ˴Ťкˤ꾼£ǯΣͤ飵ǯˤϣͤ˸뤳ȤǤθ塢ǯָ̻λԿžǯȤȡʿǯλԿϣܤȡưͭΣܡžȵͭԿΣܤˤۤ㤷äƤ롣
ʤʿǯλԿϣͤȲǰȤʤä裱ޡ裱ޡˡ
ޤưͭλԿϡ£ǯΣͤ顢ۤܰӤƸ³ʿǯˤϣͤޤǸθ壱ͤδ֤ǡФǿܤΤΡǯ飱ǿܤǯˤϣͤȤʤä裱ޡˡ
̻λԿ͸Ǥߤȡ£ǯޤǯȤȤäƱǯˤϣͤȤʤäǯʹߤϸžǯˤϣͤˤޤǸθƤäʿǯʹߤϸʿǯˤϣͤȤʤäƤ롣ư֣θ̻λԿڤӼư֣ԥθ̻λԿˤĤƤϡǯȾФޤǽĴ˸Ƥθ³Ƥ裱ޡˡ
ʤˤ̻פοͤϡ§ȤƷٻģθפˤͤǤꡢ̻λԿϡֻԿǤ롣
Τۤˡȯ壳˻˴ԡʣԡˤο򽸷פΤꡢʿǯΣԿϣͤȤʤäƤ롣ˡΦ塢ڤӹҶ̤λΤ򸶻Ȥ˴ԡʻȯ壱ǯĶƻ˴ԵڤӸɤˤ˴Ԥˤ٤Ƥʬָ̻ΡפȤƷ׾夷ƤϫƯʤο͸ưפ롣͸ưפˤ룱ǯθ̻λ˴ԿϣͤǡΤ餫ƻϩθ̻ΤǤϤʤȽǤ줿ΤٻģǤϡָפλԿפȤƣͷ׾夷Ƥ롣
EOT
}

$text = escapeHTML($text);

print << "EOT";
<hr>
<form method="post">
<textarea name="txt" rows="25" cols="80">$text</textarea>
<br>
Number of Keywords: <select name="maxwords"><option>5<option>10<option>20</select><br>
Threshold: <select name="threshold"><option>3<option selected>5<option>7<option>10<option>15</select>
<br>
<input type="submit" value="ɤ">
</form>
EOT
