# Generated by default/object.tt
package Paws::SecurityHub::AwsApiGatewayV2StageDetails;
  use Moose;
  has AccessLogSettings => (is => 'ro', isa => 'Paws::SecurityHub::AwsApiGatewayAccessLogSettings');
  has ApiGatewayManaged => (is => 'ro', isa => 'Bool');
  has AutoDeploy => (is => 'ro', isa => 'Bool');
  has ClientCertificateId => (is => 'ro', isa => 'Str');
  has CreatedDate => (is => 'ro', isa => 'Str');
  has DefaultRouteSettings => (is => 'ro', isa => 'Paws::SecurityHub::AwsApiGatewayV2RouteSettings');
  has DeploymentId => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has LastDeploymentStatusMessage => (is => 'ro', isa => 'Str');
  has LastUpdatedDate => (is => 'ro', isa => 'Str');
  has RouteSettings => (is => 'ro', isa => 'Paws::SecurityHub::AwsApiGatewayV2RouteSettings');
  has StageName => (is => 'ro', isa => 'Str');
  has StageVariables => (is => 'ro', isa => 'Paws::SecurityHub::FieldMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsApiGatewayV2StageDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsApiGatewayV2StageDetails object:

  $service_obj->Method(Att1 => { AccessLogSettings => $value, ..., StageVariables => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsApiGatewayV2StageDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessLogSettings

=head1 DESCRIPTION

Contains information about a version 2 stage for Amazon API Gateway.

=head1 ATTRIBUTES


=head2 AccessLogSettings => L<Paws::SecurityHub::AwsApiGatewayAccessLogSettings>

Information about settings for logging access for the stage.


=head2 ApiGatewayManaged => Bool

Indicates whether the stage is managed by API Gateway.


=head2 AutoDeploy => Bool

Indicates whether updates to an API automatically trigger a new
deployment.


=head2 ClientCertificateId => Str

The identifier of a client certificate for a stage. Supported only for
WebSocket API calls.


=head2 CreatedDate => Str

Indicates when the stage was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 DefaultRouteSettings => L<Paws::SecurityHub::AwsApiGatewayV2RouteSettings>

Default route settings for the stage.


=head2 DeploymentId => Str

The identifier of the deployment that the stage is associated with.


=head2 Description => Str

The description of the stage.


=head2 LastDeploymentStatusMessage => Str

The status of the last deployment of a stage. Supported only if the
stage has automatic deployment enabled.


=head2 LastUpdatedDate => Str

Indicates when the stage was most recently updated.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 RouteSettings => L<Paws::SecurityHub::AwsApiGatewayV2RouteSettings>

The route settings for the stage.


=head2 StageName => Str

The name of the stage.


=head2 StageVariables => L<Paws::SecurityHub::FieldMap>

A map that defines the stage variables for the stage.

Variable names can have alphanumeric and underscore characters.

Variable values can contain the following characters:

=over

=item *

Uppercase and lowercase letters

=item *

Numbers

=item *

Special characters -._~:/?#&=,

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

