# Generated by default/object.tt
package Paws::Translate::ParallelDataConfig;
  use Moose;
  has Format => (is => 'ro', isa => 'Str', required => 1);
  has S3Uri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Translate::ParallelDataConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Translate::ParallelDataConfig object:

  $service_obj->Method(Att1 => { Format => $value, ..., S3Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Translate::ParallelDataConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Format

=head1 DESCRIPTION

Specifies the format and S3 location of the parallel data input file.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Format => Str

The format of the parallel data input file.


=head2 B<REQUIRED> S3Uri => Str

The URI of the Amazon S3 folder that contains the parallel data input
file. The folder must be in the same Region as the API endpoint you are
calling.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Translate>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

