# Generated by default/object.tt
package Paws::LicenseManager::Entitlement;
  use Moose;
  has AllowCheckIn => (is => 'ro', isa => 'Bool');
  has MaxCount => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Overage => (is => 'ro', isa => 'Bool');
  has Unit => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LicenseManager::Entitlement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LicenseManager::Entitlement object:

  $service_obj->Method(Att1 => { AllowCheckIn => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LicenseManager::Entitlement object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowCheckIn

=head1 DESCRIPTION

Describes a resource entitled for use with a license.

=head1 ATTRIBUTES


=head2 AllowCheckIn => Bool

Indicates whether check-ins are allowed.


=head2 MaxCount => Int

Maximum entitlement count. Use if the unit is not None.


=head2 B<REQUIRED> Name => Str

Entitlement name.


=head2 Overage => Bool

Indicates whether overages are allowed.


=head2 B<REQUIRED> Unit => Str

Entitlement unit.


=head2 Value => Str

Entitlement resource. Use only if the unit is None.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LicenseManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

