# Generated by default/object.tt
package Paws::AppRunner::ConnectionSummary;
  use Moose;
  has ConnectionArn => (is => 'ro', isa => 'Str');
  has ConnectionName => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has ProviderType => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::ConnectionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::ConnectionSummary object:

  $service_obj->Method(Att1 => { ConnectionArn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::ConnectionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ConnectionArn

=head1 DESCRIPTION

Provides summary information about an AWS App Runner connection
resource.

=head1 ATTRIBUTES


=head2 ConnectionArn => Str

The Amazon Resource Name (ARN) of this connection.


=head2 ConnectionName => Str

The customer-provided connection name.


=head2 CreatedAt => Str

The App Runner connection creation time, expressed as a Unix time
stamp.


=head2 ProviderType => Str

The source repository provider.


=head2 Status => Str

The current state of the App Runner connection. When the state is
C<AVAILABLE>, you can use the connection to create an App Runner
service.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

