package Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail;
$Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail::VERSION = '3.06';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Date_of : ATTR(:get<Date>);
    my %WindowDetails_of : ATTR(:get<WindowDetails>);

    __PACKAGE__->_factory(
        [   qw(        Date
              WindowDetails

            )
        ],
        {   'Date'          => \%Date_of,
            'WindowDetails' => \%WindowDetails_of,
        },
        {   'Date'          => 'SOAP::WSDL::XSD::Typelib::Builtin::date',
            'WindowDetails' =>
              'Shipment::FedEx::WSDL::TrackTypes::AppointmentTimeDetail',
        },
        {

            'Date'          => 'Date',
            'WindowDetails' => 'WindowDetails',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail

=head1 VERSION

version 3.06

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AppointmentDetail from the namespace http://fedex.com/ws/track/v9.

Specifies the different appointment times on a specific date.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Date

=item * WindowDetails

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail
   Date =>  $some_value, # date
   WindowDetails =>  { # Shipment::FedEx::WSDL::TrackTypes::AppointmentTimeDetail
     Type => $some_value, # AppointmentWindowType
     Window =>  { # Shipment::FedEx::WSDL::TrackTypes::LocalTimeRange
       Begins =>  $some_value, # string
       Ends =>  $some_value, # string
     },
     Description =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
