package Shipment::FedEx::WSDL::TrackTypes::Contact;
$Shipment::FedEx::WSDL::TrackTypes::Contact::VERSION = '3.08';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %PersonName_of : ATTR(:get<PersonName>);
    my %Title_of : ATTR(:get<Title>);
    my %CompanyName_of : ATTR(:get<CompanyName>);
    my %PhoneNumber_of : ATTR(:get<PhoneNumber>);
    my %PhoneExtension_of : ATTR(:get<PhoneExtension>);
    my %TollFreePhoneNumber_of : ATTR(:get<TollFreePhoneNumber>);
    my %PagerNumber_of : ATTR(:get<PagerNumber>);
    my %FaxNumber_of : ATTR(:get<FaxNumber>);
    my %EMailAddress_of : ATTR(:get<EMailAddress>);

    __PACKAGE__->_factory(
        [   qw(        PersonName
              Title
              CompanyName
              PhoneNumber
              PhoneExtension
              TollFreePhoneNumber
              PagerNumber
              FaxNumber
              EMailAddress

            )
        ],
        {   'PersonName'          => \%PersonName_of,
            'Title'               => \%Title_of,
            'CompanyName'         => \%CompanyName_of,
            'PhoneNumber'         => \%PhoneNumber_of,
            'PhoneExtension'      => \%PhoneExtension_of,
            'TollFreePhoneNumber' => \%TollFreePhoneNumber_of,
            'PagerNumber'         => \%PagerNumber_of,
            'FaxNumber'           => \%FaxNumber_of,
            'EMailAddress'        => \%EMailAddress_of,
        },
        {   'PersonName'     => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Title'          => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'CompanyName'    => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PhoneNumber'    => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PhoneExtension' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'TollFreePhoneNumber' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PagerNumber'  => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'FaxNumber'    => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'EMailAddress' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'PersonName'          => 'PersonName',
            'Title'               => 'Title',
            'CompanyName'         => 'CompanyName',
            'PhoneNumber'         => 'PhoneNumber',
            'PhoneExtension'      => 'PhoneExtension',
            'TollFreePhoneNumber' => 'TollFreePhoneNumber',
            'PagerNumber'         => 'PagerNumber',
            'FaxNumber'           => 'FaxNumber',
            'EMailAddress'        => 'EMailAddress',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::Contact

=head1 VERSION

version 3.08

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Contact from the namespace http://fedex.com/ws/track/v9.

The descriptive data for a point-of-contact person.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PersonName

=item * Title

=item * CompanyName

=item * PhoneNumber

=item * PhoneExtension

=item * TollFreePhoneNumber

=item * PagerNumber

=item * FaxNumber

=item * EMailAddress

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::Contact

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::Contact
   PersonName =>  $some_value, # string
   Title =>  $some_value, # string
   CompanyName =>  $some_value, # string
   PhoneNumber =>  $some_value, # string
   PhoneExtension =>  $some_value, # string
   TollFreePhoneNumber =>  $some_value, # string
   PagerNumber =>  $some_value, # string
   FaxNumber =>  $some_value, # string
   EMailAddress =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
