use 5.006;    # our
use strict;
use warnings;

package inc::My::NeoMakeMaker;

# ABSTRACT: An example MakeMaker with Beam

# AUTHORITY

use Moose qw( around extends with has );
extends 'Dist::Zilla::Plugin::MakeMaker';
with 'Beam::Emitter';
use List::Util qw( first );

# PS: This example shows exactly how much you need to piss around with EUMM
# just to get some basic stuff done.

has 'static_attribution' => (
    isa => 'Bool',
    is  => 'ro',
);

around write_makefile_args => sub {
    my ( $orig, $self, @args ) = @_;
    my $args  = $self->$orig(@args);
    my $event = $_[1]->emit(
        'augment_makefile_args' => class => 'My::MakeMaker::Args',
        args                    => $args
    );
    return $event->args;
};

my $template = q!# This file was automatically generated by {{ $generated_by }}.
use strict;
use warnings;

{{ $perl_prereq ? qq[use $perl_prereq;] : ''; }}

use ExtUtils::MakeMaker{{ defined $eumm_version && 0+$eumm_version ? ' ' . $eumm_version : '' }};
{{ $share_dir_code{preamble} || '' }}
my {{ $WriteMakefileArgs }}

my {{ $fallback_prereqs }}

XXXPRELUDEXXX

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
{{ $share_dir_code{postamble} || '' }}!;

sub gather_files {
    my ($self) = @_;

    require Dist::Zilla::File::InMemory;

    my $event =
      $self->emit( 'generate_prelude', class => 'My::MakeMaker::Prelude' );

    $self->log_debug( [ "Prelude was <%s>", $event->prelude ] );
    my $templ = $template;
    $templ =~ s{XXXPRELUDEXXX}{ $event->prelude }sex;

    my $file = Dist::Zilla::File::InMemory->new(
        {
            name    => 'Makefile.PL',
            content => $templ,          # template evaluated later
        }
    );

    $self->add_file($file);
    return;
}

sub setup_installer {
    my ($self) = @_;

    my $write_makefile_args = $self->write_makefile_args;

    $self->__write_makefile_args($write_makefile_args);    # save for testing

    my $perl_prereq = $write_makefile_args->{MIN_PERL_VERSION};

    my $dumped_args =
      $self->_dump_as( $write_makefile_args, '*WriteMakefileArgs' );

    my $file = first { $_->name eq 'Makefile.PL' } @{ $self->zilla->files };

    $self->log_debug( ['updating contents of Makefile.PL in memory'] );

    my $attribution =
      $self->static_attribution
      ? ref($self)
      : sprintf( "%s v%s", ref($self), $self->VERSION || '(dev)' );

    my $event = $self->emit(
        'augment_template_args',
        class => 'My::MakeMaker::TemplateArgs',
        args  => {
            eumm_version      => \( $self->eumm_version ),
            perl_prereq       => \$perl_prereq,
            share_dir_code    => $self->share_dir_code,
            fallback_prereqs  => \( $self->fallback_prereq_pm ),
            WriteMakefileArgs => \$dumped_args,
            generated_by      => \$attribution,
        }
    );
    my $content = $self->fill_in_string( $file->content, $event->args, );

    $file->content($content);

    return;
}

__PACKAGE__->meta->make_immutable;
no Moose;

package My::MakeMaker::Args;

use Moose qw( extends has );

extends 'Beam::Event';

has 'args' => ( is => 'ro', required => 1 );

__PACKAGE__->meta->make_immutable;

no Moose;

package My::MakeMaker::Prelude;

use Moose qw( extends has );

extends 'Beam::Event';

has 'prelude' => ( is => 'rw', default => '' );

__PACKAGE__->meta->make_immutable;

no Moose;

package My::MakeMaker::TemplateArgs;

use Moose qw( extends has );

extends 'Beam::Event';

has 'args' => ( is => 'ro', required => 1 );

__PACKAGE__->meta->make_immutable;

no Moose;

1;
