#!/usr/bin/perl

use strict;
use warnings;

use utf8;



package WWW::Shopify::Field::String;
use parent 'WWW::Shopify::Field';


my @utf8_characters = split(//, '漢字仮名交じり文åФХѾЦЧШЩЪЫЬѢꙖѤЮѦѪѨѬѠѺѮѰѲѴΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩ');
sub rand_utf8_char { return rand() < 0.5 ? $utf8_characters[int(rand(int(@utf8_characters)))] : ''; }

sub sql_type { return "varchar(255)"; }
sub generate($) {
	return $_[0]->{arguments}->[0] if int(@{$_[0]->{arguments}} > 0);
	#return join("", map { chr(int(rand()*10000+100)) } 1..(rand(16)+1));
	return join("-", map { lc($_) . __PACKAGE__->rand_utf8_char() } ::rand_words(size => int(rand(2))+1));
}

package WWW::Shopify::Field::String::Regex;
use parent 'WWW::Shopify::Field::String';
sub sql_type { return "varchar(255)"; }
sub generate($) {
	return ::random_regex($_[0]->{arguments}->[0]) if int(@{$_[0]->{arguments}} > 0);
	return ::random_regex('\w{1,40}') . __PACKAGE__->rand_utf8_char();
}


package WWW::Shopify::Field::String::Password;
use parent 'WWW::Shopify::Field::String';
sub generate($) {
	return ::random_regex('\w{1,40}');
}

package WWW::Shopify::Field::String::Words;
use parent 'WWW::Shopify::Field::String';
sub generate($) {
	my ($self, $min, $max, $join) = @_;
	($min, $max, $join) = @{$_[0]->{arguments}} if ref($self);
	$join = " " unless defined $join;
	$max = 20 if defined $max && $max eq "*";
	return join($join, map { $_ . __PACKAGE__->rand_utf8_char() } ::rand_words(size => (int($max - $min) + $min))) if defined $max;
	return join($join, map { $_ . __PACKAGE__->rand_utf8_char() } ::rand_words(size => $min)) if defined $min;
	return join($join, map { $_ . __PACKAGE__->rand_utf8_char() } ::rand_words(size => int(rand(30))+1)) if (!ref($_[0]) || int(@{$_[0]->{arguments}}) == 0);
}
sub sql_type { return 'TEXT'; }

package WWW::Shopify::Field::String::Hash;
use parent 'WWW::Shopify::Field::String';
sub generate($) {
	return ::random_regex('[a-f0-9]{64}');
}

package WWW::Shopify::Field::String::URL;
use parent 'WWW::Shopify::Field::String';

sub sql_type { return 'TEXT'; }
sub generate($) {
	return 'http://www.' . ::random_regex('[a-z_0-9]{3,24}') . '.com/' . ::random_regex('[a-z_0-9]{0,16}');
}


package WWW::Shopify::Field::String::URL::Domain;
use base 'WWW::Shopify::Field::String::URL';
sub generate($) {
	return ::random_regex('[a-z_0-9]{3,24}') . '.com';
}


package WWW::Shopify::Field::String::URL::Long;
use parent 'WWW::Shopify::Field::String';
sub sql_type { return 'TEXT'; }
sub generate($) {
	return 'http://www.' . ::random_regex('[a-z_0-9]{3,24}') . '.com/' . ::random_regex('[a-z_0-9]{0,16}');
}


package WWW::Shopify::Field::String::URL::Shopify;
use parent 'WWW::Shopify::Field::String';
sub sql_type { return 'TEXT'; }
sub generate($) {
	return 'http://www.' . ::random_regex('[a-z_0-9]{3,24}') . '.myshopify.com/' . ::random_regex('[a-z_0-9]{0,16}');
}

# We'll just generate like 1000 images in this folder.
package WWW::Shopify::Field::String::URL::Image;
use parent 'WWW::Shopify::Field::String';
sub sql_type { return 'TEXT'; }
sub generate($) {
	return '/mock/images/' . ::random_regex('[a-z_0-9]{1,8}') . ".png";
}

package WWW::Shopify::Field::String::Email;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return ::random_regex('[a-z]{3,10}@gmail') . '.com';
}

package WWW::Shopify::Field::String::Base64;
use parent 'WWW::Shopify::Field::String';

package WWW::Shopify::Field::String::Name;
use parent 'WWW::Shopify::Field::String';

sub generate {
	my @first_names = qw(James John Robert Michael William David Richard Charles Joseph Thomas Christopher Daniel Paul Mark Donald George Kenneth Steven Edward Brian Ronald Anthony Kevin Jason Matthew Gary Timothy Jose Larry Jeffrey Frank Scott Eric Stephen Andrew Raymond Gregory Joshua Jerry Dennis Walter Patrick Peter Harold Douglas Henry Carl Arthur Ryan Roger Joe Juan Jack Albert Jonathan Justin Terry Gerald Keith Samuel Willie Ralph Lawrence Nicholas Roy Benjamin Bruce Brandon Adam Harry Fred Wayne Billy Steve Louis Jeremy Aaron Randy Howard Eugene Carlos Russell Bobby Victor Martin Ernest Phillip Todd Jesse Craig Alan Shawn Clarence Sean Philip Chris Johnny Earl Jimmy Antonio Danny Bryan Tony Luis Mike Stanley Leonard Nathan Dale Manuel Rodney Curtis Norman Allen Marvin Vincent Glenn Jeffery Travis Jeff Chad Jacob Lee Melvin Alfred Kyle Francis Bradley Jesus Herbert Frederick Ray Joel Edwin Don Eddie Ricky Troy Randall Barry Alexander Bernard Mario Leroy Francisco Marcus Micheal Theodore Clifford Miguel Oscar Jay Jim Tom Calvin Alex Jon Ronnie Bill Lloyd Tommy Leon Derek Warren Darrell Jerome Floyd Leo Alvin Tim Wesley Gordon Dean Greg Jorge Dustin Pedro Derrick Dan Lewis Zachary Corey Herman Maurice Vernon Roberto Clyde Glen Hector Shane Ricardo Sam Rick Lester Brent Ramon Charlie Tyler Gilbert Gene Marc Reginald Ruben Brett Angel Nathaniel Rafael Leslie Edgar Milton Raul Ben Chester Cecil Duane Franklin Andre Elmer Brad Gabriel Ron Mitchell Roland Arnold Harvey Jared Adrian Karl Cory Claude Erik Darryl Jamie Neil Jessie Christian Javier Fernando Clinton Ted Mathew Tyrone Darren Lonnie Lance Cody Julio Kelly Kurt Allan Nelson Guy Clayton Hugh Max Dwayne Dwight Armando Felix Jimmie Everett Jordan Ian Wallace Ken Bob Jaime Casey Alfredo Alberto Dave Ivan Johnnie Sidney Byron Julian Isaac Morris Clifton Willard Daryl Ross Virgil Andy Marshall Salvador Perry Kirk Sergio Marion Tracy Seth Kent Terrance Rene Eduardo Terrence Enrique Freddie Wade Austin Hal Brain Rob Elwood Kendrick Darius Moises Son Marlin Fidel Thaddeus Cliff Marcel Ali Jackson Raphael Bryon Armand Alvaro Jeffry Dane Joesph Thurman Ned Sammie Rusty Michel Monty Rory Fabian Reggie Mason Graham Kris Isaiah Vaughn Gus Avery Loyd Diego Alexis Adolph Norris Millard Rocco Gonzalo Derick Rodrigo Gerry Stacey Carmen Wiley Rigoberto Alphonso Ty Shelby Rickie Noe Vern Bobbie Reed Jefferson Elvis Bernardo Mauricio Hiram Donovan Basil Riley Ollie Nickolas Maynard Scot Vince Quincy Eddy Sebastian Federico Ulysses Heriberto Donnell Cole Denny Davis Gavin Emery Ward Romeo Jayson Dion Dante Clement Coy Odell Maxwell Jarvis Bruno Issac Mary Dudley Brock Sanford Colby Carmelo Barney Nestor Hollis Stefan Donny Art Linwood Beau Weldon Galen Isidro Truman Delmar Johnathon Silas Frederic Dick Kirby Irwin Cruz Merlin Merrill Charley Marcelino Lane Harris Cleo Carlo Trenton Kurtis Hunter Aurelio Winfred Vito Collin Denver Carter Leonel Emory Pasquale Mohammad Mariano Danial Blair Landon Dirk Branden Adan Numbers Clair Buford German Bernie Wilmer Joan Emerson Zachery Fletcher Jacques Errol Dalton Monroe Josue Dominique Edwardo Booker Wilford Sonny Shelton Carson Theron Raymundo Daren Tristan Houston Robby Lincoln Jame Genaro Gale Bennett Octavio Cornell Laverne Hung Arron Antony Herschel Alva Giovanni Garth Cyrus Cyril Ronny Stevie Lon Freeman Erin Duncan Kennith Carmine Augustine Young Erich Chadwick Wilburn Russ Reid Myles Anderson Morton Jonas Forest Mitchel Mervin Zane Rich Jamel Lazaro Alphonse Randell Major Johnie Jarrett Brooks Ariel Abdul Dusty Luciano Lindsey Tracey Seymour Scottie Eugenio Mohammed Sandy Valentin Chance Arnulfo Lucien Ferdinand Thad Ezra Sydney Aldo Rubin Royal Mitch Earle Abe Wyatt Marquis Lanny Kareem Jamar Boris Isiah Emile Elmo Aron Leopoldo Everette Josef Gail Eloy Dorian Rodrick Reinaldo Lucio Jerrod Weston Hershel Barton Parker Lemuel Lavern Burt Jules Gil Eliseo Ahmad Nigel Efren Antwan Alden Margarito Coleman Refugio Dino Osvaldo Les Deandre Normand Kieth Ivory Andrea Trey Norberto Napoleon Jerold Fritz Rosendo Milford Sang Deon Christoper Alfonzo Lyman Josiah Brant Wilton Rico Jamaal Dewitt Carol Brenton Yong Olin Foster Faustino Claudio Judson Gino Edgardo Berry Alec Tanner Jarred Donn Trinidad Tad Shirley Prince Porfirio Odis Maria Lenard Chauncey Chang Tod Mel Marcelo Kory Augustus Keven Hilario Bud Sal Rosario Orval Mauro Dannie Zachariah Olen Anibal Milo Jed Frances Thanh Dillon Amado Newton Connie Lenny Tory Richie Lupe Horacio Brice Mohamed Delmer Dario Reyes Dee Mac Jonah Jerrold Robt Hank Sung Rupert Rolland Kenton Damion Chi Antone Waldo Fredric Bradly Quinn Kip Burl Walker Tyree Jefferey Ahmed Willy Stanford Oren Noble Moshe Mikel Enoch Brendon Quintin Jamison Florencio Darrick Tobias Minh Hassan Giuseppe Demarcus Cletus Tyrell Lyndon Keenan Werner Theo Geraldo Lou Columbus Chet Bertram Markus Huey Hilton Dwain Donte Tyron Omer Isaias Hipolito Fermin Chung Adalberto Valentine Jamey Bo Barrett Whitney Teodoro Mckinley Maximo Garfield Sol Raleigh Lawerence Abram Rashad King Emmitt Daron Chong Samual Paris Otha Miquel Lacy Eusebio Dong Domenic Darron Buster Antonia Wilber Renato Jc Hoyt Haywood Ezekiel Chas Florentino Elroy Clemente Arden Neville Kelley Edison Deshawn Carrol Shayne Nathanial Jordon Danilo Claud Val Sherwood Raymon Rayford Cristobal Ambrose Titus Hyman Felton Ezequiel Erasmo Stanton Lonny Len Ike Milan Lino Jarod Herb Andreas Walton Rhett Palmer Jude Douglass Cordell Oswaldo Ellsworth Virgilio Toney Nathanael Del Britt Benedict Mose Hong Leigh Johnson Isreal Gayle Garret Fausto Asa Arlen Zack Warner Modesto Francesco Manual Jae Gaylord Gaston Filiberto Deangelo Michale Granville Wes Malik Zackary Tuan Nicky Eldridge Cristopher Cortez Antione Malcom Long Korey Jospeh Colton Waylon Von Hosea Shad Santo Rudolf Rolf Rey Renaldo Marcellus Lucius Lesley Kristofer Boyce Benton Man Kasey Jewell Hayden Harland Arnoldo Rueben Leandro Kraig Jerrell Jeromy Hobert Cedrick Arlie Winford Wally Patricia Luigi Keneth Jacinto Graig Franklyn Edmundo Sid Porter Leif Lauren Jeramy Elisha Buck Willian Vincenzo Shon Michal Lynwood Lindsay Jewel Jere Hai Elden Dorsey Darell Broderick Alonso Stuart Fredrick Arturo Alejandro Jackie Joey Nick Luther Wendell Jeremiah Evan Julius Dana Donnie Otis Shannon Trevor Oliver Luke Homer Gerard Doug Kenny Hubert Angelo Shaun Lyle Matt Lynn Alfonso Orlando Rex Carlton Ernesto Cameron Neal Pablo Lorenzo Omar Wilbur Blake Grant Horace Roderick Kerry Abraham Willis Rickey Jean Ira Andres Cesar Johnathan Malcolm Rudolph Damon Kelvin Rudy Preston Alton Archie Marco Wm Pete Randolph Garry Geoffrey Jonathon Felipe Bennie Gerardo Ed Dominic Robin Loren Delbert Colin Guillermo Earnest Lucas Benny Noel Spencer Rodolfo Myron Edmund Garrett Salvatore Cedric Lowell Gregg Sherman Wilson Devin Sylvester Kim Roosevelt Israel Jermaine Forrest Wilbert Leland Simon Guadalupe Clark Irving Carroll Bryant Owen Rufus Woodrow Sammy Kristopher Mack Levi Marcos Gustavo Jake Lionel Marty Taylor Ellis Dallas Gilberto Clint Nicolas Laurence Ismael Orville Drew Jody Ervin Dewey Al Wilfred Josh Hugo Ignacio Caleb Tomas Sheldon Erick Frankie Stewart Doyle Darrel Rogelio Terence Santiago Alonzo Elias Bert Elbert Ramiro Conrad Pat Noah Grady Phil Cornelius Lamar Rolando Clay Percy Dexter Bradford Merle Darin Amos Terrell Moses Irvin Saul Roman Darnell Randal Tommie Timmy Darrin Winston Brendan Toby Van Abel Dominick Boyd Courtney Jan Emilio Elijah Cary Domingo Santos Aubrey Emmett Marlon Emanuel Jerald Edmond Emil Dewayne Will Otto Teddy Reynaldo Bret Morgan Jess Trent Humberto Emmanuel Stephan Louie Vicente Lamont Stacy Garland Miles Micah Efrain Billie Logan Heath Rodger Harley Demetrius Ethan Eldon Rocky Pierre Junior Freddy Eli Bryce Antoine Robbie Kendall Royce Sterling Mickey Chase Grover Elton Cleveland Dylan Chuck Damian Reuben Stan August Leonardo Jasper Russel Erwin Benito Hans Monte Blaine Ernie Curt Quentin Agustin Murray Jamal Devon Adolfo Harrison Tyson Burton Brady Elliott Wilfredo Bart Jarrod Vance Denis Damien Joaquin Harlan Desmond Elliot Darwin Ashley Gregorio Buddy Xavier Kermit Roscoe Esteban Anton Solomon Scotty Norbert Elvin Williams Nolan Carey Rod Quinton Mary Patricia Linda Barbara Elizabeth Jennifer Maria Susan Margaret Dorothy Lisa Nancy Karen Betty Helen Sandra Donna Carol Ruth Sharon Michelle Laura Sarah Kimberly Deborah Jessica Shirley Cynthia Angela Melissa Brenda Amy Anna Rebecca Virginia Kathleen Pamela Martha Debra Amanda Stephanie Carolyn Christine Marie Janet Catherine Frances Ann Joyce Diane Alice Julie Heather Teresa Doris Gloria Evelyn Jean Cheryl Mildred Katherine Joan Ashley Judith Rose Janice Kelly Nicole Judy Christina Kathy Theresa Beverly Denise Tammy Irene Jane Lori Rachel Marilyn Andrea Kathryn Louise Sara Anne Jacqueline Wanda Bonnie Julia Ruby Lois Tina Phyllis Norma Paula Diana Annie Lillian Emily Robin Peggy Crystal Gladys Rita Dawn Connie Florence Tracy Edna Tiffany Carmen Rosa Cindy Grace Wendy Victoria Edith Kim Sherry Sylvia Josephine Thelma Shannon Sheila Ethel Ellen Elaine Marjorie Carrie Charlotte Monica Esther Pauline Emma Juanita Anita Rhonda Hazel Amber Eva Debbie April Leslie Clara Lucille Jamie Joanne Eleanor Valerie Danielle Megan Alicia Suzanne Michele Gail Bertha Darlene Veronica Jill Erin Geraldine Lauren Cathy Joann Lorraine Lynn Sally Regina Erica Beatrice Dolores Bernice Audrey Yvonne Annette June Samantha Marion Dana Stacy Ana Renee Ida Vivian Roberta Holly Brittany Melanie Loretta Yolanda Jeanette Laurie Katie Kristen Vanessa Alma Sue Elsie Beth Jeanne Vicki Carla Tara Rosemary Eileen Terri Gertrude Lucy Tonya Ella Stacey Wilma Gina Kristin Jessie Natalie Agnes Vera Willie Charlene Bessie Delores Melinda Pearl Arlene Maureen Colleen Allison Tamara Joy Georgia Constance Lillie Claudia Jackie Marcia Tanya Nellie Minnie Marlene Heidi Glenda Lydia Viola Courtney Marian Stella Caroline Dora Jo Vickie Mattie Terry Maxine Irma Mabel Marsha Myrtle Lena Christy Deanna Patsy Hilda Gwendolyn Jennie Nora Margie Nina Cassandra Leah Penny Kay Priscilla Naomi Carole Brandy Olga Billie Dianne Tracey Leona Jenny Felicia Sonia Miriam Velma Becky Bobbie Violet Kristina Toni Misty Mae Shelly Daisy Ramona Sherri Erika Katrina Claire Lindsey Lindsay Geneva Guadalupe Belinda Margarita Sheryl Cora Faye Ada Natasha Sabrina Isabel Marguerite Hattie Harriet Molly Cecilia Kristi Brandi Blanche Sandy Rosie Joanna Iris Eunice Angie Inez Lynda Madeline Amelia Alberta Genevieve Monique Jodi Janie Maggie Kayla Sonya Jan Lee Kristine Candace Fannie Maryann Opal Alison Yvette Melody Luz Susie Olivia Flora Shelley Kristy Mamie Lula Lola Verna Beulah Antoinette Candice Juana Jeannette Pam Kelli Hannah Whitney Bridget Karla Celia Latoya Patty Shelia Gayle Della Vicky Lynne Sheri Marianne Kara Jacquelyn Erma Blanca Myra Leticia Pat Krista Roxanne Angelica Johnnie Robyn Francis Adrienne Rosalie Alexandra Brooke Bethany Sadie Bernadette Traci Jody Kendra Jasmine Nichole Rachael Chelsea Mable Ernestine Muriel Marcella Elena Krystal Angelina Nadine Kari Estelle Dianna Paulette Lora Mona Doreen Rosemarie Angel Desiree Antonia Hope Ginger Janis Betsy Christie Freda Mercedes Meredith Lynette Teri Cristina Eula Leigh Meghan Sophia Eloise Rochelle Gretchen Cecelia Raquel Henrietta Alyssa Jana Kelley Gwen Kerry Jenna Tricia Laverne Olive Alexis Tasha Silvia Elvira Casey Delia Sophie Kate Patti Lorena Kellie Sonja Lila Lana Darla May Mindy Essie Mandy Lorene Elsa Josefina Jeannie Miranda Dixie Lucia Marta Faith Lela Johanna Shari Camille Tami Shawna Elisa Ebony Melba Ora Nettie Tabitha Ollie Jaime Winifred Kristie Marina Alisha Aimee Rena Myrna Marla Tammie Latasha Bonita Patrice Ronda Sherrie Addie Francine Deloris Stacie Adriana Cheri Shelby Abigail Celeste Jewel Cara Adele Rebekah Lucinda Dorthy Chris Effie Trina Reba Shawn Sallie Aurora Lenora Etta Lottie Kerri Trisha Nikki Estella Francisca Josie Tracie Marissa Karin Brittney Janelle Lourdes Laurel Helene Fern Elva Corinne Kelsey Ina Bettie Elisabeth Aida Caitlin Ingrid Iva Eugenia Christa Goldie Cassie Maude Jenifer Therese Frankie Dena Lorna Janette Latonya Candy Morgan Consuelo Tamika Rosetta Debora Cherie Polly Dina Jewell Fay Jillian Dorothea Nell Trudy Esperanza Patrica Kimberley Shanna Helena Carolina Cleo Stefanie Rosario Ola Janine Mollie Lupe Alisa Lou Maribel Susanne Bette Susana Elise Cecile Isabelle Lesley Jocelyn Paige Joni Rachelle Leola Daphne Alta Ester Petra Graciela Imogene Jolene Keisha Lacey Glenna Gabriela Keri Ursula Lizzie Kirsten Shana Adeline Mayra Jayne Jaclyn Gracie Sondra Carmela Marisa Rosalind Charity Tonia Beatriz Marisol Clarice Jeanine Sheena Angeline Frieda Lily Robbie Shauna Millie Claudette Cathleen Angelia Gabrielle Autumn Katharine Summer Jodie Staci Lea Christi Jimmie Justine Elma Luella Margret Dominique Socorro Rene Martina Margo Mavis Callie Bobbi Maritza Lucile Leanne Jeannine Deana Aileen Lorie Ladonna Willa Manuela Gale Selma Dolly Sybil Abby Lara Dale Ivy Dee Winnie Marcy Luisa Jeri Magdalena Ofelia Meagan Audra Matilda Leila Cornelia Bianca Simone Bettye Randi Virgie Latisha Barbra Georgina Eliza Leann Bridgette Rhoda Haley Adela Nola Bernadine Flossie Ila Greta Ruthie Nelda Minerva Lilly Terrie Letha Hilary Estela Valarie Brianna Rosalyn Earline Catalina Ava Mia Clarissa Lidia Corrine Alexandria Concepcion Tia Sharron Rae Dona Ericka Jami Elnora Chandra Lenore Neva Marylou Melisa Tabatha Serena Avis Allie Sofia Jeanie Odessa Nannie Harriett Loraine Penelope Milagros Emilia Benita Allyson Ashlee Tania Tommie Esmeralda Karina Eve Pearlie Zelma Malinda Noreen Tameka Saundra Hillary Amie Althea Rosalinda Jordan Lilia Alana Gay Clare Alejandra Elinor Michael Lorrie Jerri Darcy Earnestine Carmella Taylor Noemi Marcie Liza Annabelle Louisa Earlene Mallory Carlene Nita Selena Tanisha Katy Julianne John Lakisha Edwina Maricela Margery Kenya Dollie Roxie Roslyn Kathrine Nanette Charmaine Lavonne Ilene Kris Tammi Suzette Corine Kaye Jerry Merle Chrystal Lina Deanne Lilian Juliana Aline Luann Kasey Maryanne Evangeline Colette Melva Lawanda Yesenia Nadia Madge Kathie Eddie Ophelia Valeria Nona Mitzi Mari Georgette Claudine Fran Alissa Roseann Lakeisha Susanna Reva Deidre Chasity Sheree Carly James Elvia Alyce Deirdre Gena Briana Araceli Katelyn Rosanne Wendi Tessa Berta Marva Imelda Marietta Marci Leonor Arline Sasha Madelyn Janna Juliette Deena Aurelia Josefa Augusta Liliana Young Christian Lessie Amalia Savannah Anastasia Vilma Natalia Rosella Lynnette Corina Alfreda Leanna Carey Amparo Coleen Tamra Aisha Wilda Karyn Cherry Queen Maura Mai Evangelina Rosanna Hallie Erna Enid Mariana Lacy Juliet Jacklyn Freida Madeleine Mara Hester Cathryn Lelia Casandra Bridgett Angelita Jannie Dionne Annmarie Katina Beryl Phoebe Millicent Katheryn Diann Carissa Maryellen Liz Lauri Helga Gilda Adrian Rhea Marquita Hollie Tisha Tamera Angelique Francesca Britney Kaitlin Lolita Florine Rowena Reyna Twila Fanny Janell Ines Concetta Bertie Alba Brigitte Alyson Vonda Pansy Elba Noelle Letitia Kitty Deann Brandie Louella Leta Felecia Sharlene Lesa Beverley Robert Isabella Herminia Terra Celina);
	my @last_names = qw(Smith Johnson Williams Brown Jones Miller Davis Garcia Rodriguez Wilson Martinez Anderson Taylor Thomas Hernandez Moore Martin Jackson Thompson White Lopez Lee Gonzalez Harris Clark Lewis Robinson Walker Perez Hall Young Allen Sanchez Wright King Scott Green Baker Adams Nelson Hill Ramirez Campbell Mitchell Roberts Carter Phillips Evans Turner Torres Parker Collins Edwards Stewart Flores Morris Nguyen Murphy Rivera Cook Rogers Morgan Peterson Cooper Reed Bailey Bell Gomez Kelly Howard Ward Cox Diaz Richardson Wood Watson Brooks Bennett Gray James Reyes Cruz Hughes Price Myers Long Foster Sanders Ross Morales Powell Sullivan Russell Ortiz Jenkins Gutierrez Perry Butler Barnes Fisher Henderson Coleman Simmons Patterson Jordan Reynolds Hamilton Graham Kim Gonzales Alexander Ramos Wallace Griffin West Cole Hayes Chavez Gibson Bryant Ellis Stevens Murray Ford Marshall Owens Mcdonald Harrison Ruiz Kennedy Wells Alvarez Woods Mendoza Castillo Olson Webb Washington Tucker Freeman Burns Henry Vasquez Snyder Simpson Crawford Jimenez Porter Mason Shaw Gordon Wagner Hunter Romero Hicks Dixon Hunt Palmer Robertson Black Holmes Stone Meyer Boyd Mills Warren Fox Rose Rice Moreno Schmidt Patel Ferguson Nichols Herrera Medina Ryan Fernandez Weaver Daniels Stephens Gardner Payne Kelley Dunn Pierce Arnold Tran Spencer Peters Hawkins Grant Hansen Castro Hoffman Hart Elliott Cunningham Knight Bradley Carroll Hudson Duncan Armstrong Berry Andrews Johnston Ray Lane Riley Carpenter Perkins Aguilar Silva Richards Willis Matthews Chapman Lawrence Garza Vargas Watkins Wheeler Larson Carlson Harper George Greene Burke Guzman Morrison Munoz Jacobs Obrien Lawson Franklin Lynch Bishop Carr Salazar Austin Mendez Gilbert Jensen Williamson Montgomery Harvey Oliver Howell Dean Hanson Weber Garrett Sims Burton Fuller Soto Mccoy Welch Chen Schultz Walters Reid Fields Walsh Little Fowler Bowman Davidson May Day Schneider Newman Brewer Lucas Holland Wong Banks Santos Curtis Pearson Delgado Valdez Pena Rios Douglas Sandoval Barrett Hopkins Keller Guerrero Stanley Bates Alvarado Beck Ortega Wade Estrada Contreras Barnett Caldwell Santiago Lambert Powers Chambers Nunez Craig Leonard Lowe Rhodes Byrd Gregory Shelton Frazier Becker Maldonado Fleming Vega Sutton Cohen Jennings Parks Mcdaniel Watts Barker Norris Vaughn Vazquez Holt Schwartz Steele Benson Neal Dominguez Horton Terry Wolfe Hale Lyons Graves Haynes Miles Park Warner Padilla Bush Thornton Mccarthy Mann Zimmerman Erickson Fletcher Mckinney Page Dawson Joseph Marquez Reeves Klein Espinoza Baldwin Moran Love Robbins Higgins Ball Cortez Le Griffith Bowen Sharp Cummings Ramsey Hardy Swanson Barber Acosta Luna Chandler Blair Daniel Cross Simon Dennis Oconnor Quinn Gross Navarro Moss Fitzgerald Doyle Mclaughlin Rojas Rodgers Stevenson Singh Yang Figueroa Harmon Newton Paul Manning Garner Mcgee Reese Francis Burgess Adkins Goodman Curry Brady Christensen Potter Walton Goodwin Mullins Molina Webster Fischer Campos Avila Sherman Todd Chang Blake Malone Wolf Hodges Juarez Gill Farmer Hines Gallagher Duran Hubbard Cannon Miranda Wang Saunders Tate Mack Hammond Carrillo Townsend Wise Ingram Barton Mejia Ayala Schroeder Hampton Rowe Parsons Frank Waters Strickland Osborne Maxwell Chan Deleon Norman Harrington Casey Patton Logan Bowers Mueller Glover Floyd Hartman Buchanan Cobb French Kramer Mccormick Clarke Tyler Gibbs Moody Conner Sparks Mcguire Leon Bauer Norton Pope Flynn Hogan Robles Salinas Yates Lindsey Lloyd Marsh Mcbride Owen Solis Pham Lang Pratt Lara Brock Ballard Trujillo Shaffer Drake Roman Aguirre Morton Stokes Lamb Pacheco Patrick Cochran Shepherd Cain Burnett Hess Li Cervantes Olsen Briggs Ochoa Cabrera Velasquez Montoya Roth Meyers Cardenas Fuentes Weiss Hoover Wilkins Nicholson Underwood Short Carson Morrow Colon Holloway Summers Bryan Petersen Mckenzie Serrano Wilcox Carey Clayton Poole Calderon Gallegos Greer Rivas Guerra Decker Collier Wall Whitaker Bass Flowers Davenport Conley Houston Huff Copeland Hood Monroe Massey Roberson Combs Franco Larsen Pittman Randall Skinner Wilkinson Kirby Cameron Bridges Anthony Richard Kirk Bruce Singleton Mathis Bradford Boone Abbott Charles Allison Sweeney Atkinson Horn Jefferson Rosales York Christian Phelps Farrell Castaneda Nash Dickerson Bond Wyatt Foley Chase Gates Vincent Mathews Hodge Garrison Trevino Villarreal Heath Dalton Valencia Callahan Hensley Atkins Huffman Roy Boyer Shields Lin Hancock Grimes Glenn Cline Delacruz Camacho Dillon Parrish Oneill Melton Booth Kane Berg Harrell Pitts Savage Wiggins Brennan Salas Marks Russo Sawyer Baxter Golden Hutchinson Liu Walter Mcdowell Wiley Rich Humphrey Johns Koch Suarez Hobbs Beard Gilmore Ibarra Keith Macias Khan Andrade Ware Stephenson Henson Wilkerson Dyer Mcclure Blackwell Mercado Tanner Eaton Clay Barron Beasley Oneal Preston Small Wu Zamora Macdonald Vance Snow Mcclain Stafford Orozco Barry English Shannon Kline Jacobson Woodard Huang Kemp Mosley Prince Merritt Hurst Villanueva Roach Nolan Lam Yoder Mccullough Lester Santana Valenzuela Winters Barrera Leach Orr Berger Mckee Strong Conway Stein Whitehead Bullock Escobar Knox Meadows Solomon Velez Odonnell Kerr Stout Blankenship Browning Kent Lozano Bartlett Pruitt Buck Barr Gaines Durham Gentry Mcintyre Sloan Melendez Rocha Herman Sexton Moon Hendricks Rangel Stark Lowery Hardin Hull Sellers Ellison Calhoun Gillespie Mora Knapp Mccall Morse Dorsey Weeks Nielsen Livingston Leblanc Mclean Bradshaw Glass Middleton Buckley Schaefer Frost Howe House Mcintosh Ho Pennington Reilly Hebert Mcfarland Hickman Noble Spears Conrad Arias Galvan Velazquez Huynh Frederick Randolph Cantu Fitzpatrick Mahoney Peck Villa Michael Donovan Mcconnell Walls Boyle Mayer Zuniga Giles Pineda Pace Hurley Mays Mcmillan Crosby Ayers Case Bentley Shepard Everett Pugh David Mcmahon Dunlap Bender Hahn Harding Acevedo Raymond Blackburn Duffy Landry Dougherty Bautista Shah Potts Arroyo Valentine Meza Gould Vaughan Fry Rush Avery Herring Dodson Clements Sampson Tapia Bean Lynn Crane Farley Cisneros Benton Ashley Mckay Finley Best Blevins Friedman Moses Sosa Blanchard Huber Frye Krueger Bernard Rosario Rubio Mullen Benjamin Haley Chung Moyer Choi Horne Yu Woodward Ali Nixon Hayden Rivers Estes Mccarty Richmond Stuart Maynard Brandt Oconnell Hanna Sanford Sheppard Church Burch Levy Rasmussen Coffey Ponce Faulkner Donaldson Schmitt Novak Costa Montes Booker Cordova Waller Arellano Maddox Mata Bonilla Stanton Compton Kaufman Dudley Mcpherson Beltran Dickson Mccann Villegas Proctor Hester Cantrell Daugherty Cherry Bray Davila Rowland Levine Madden Spence Good Irwin Werner Krause Petty Whitney Baird Hooper Pollard Zavala Jarvis Holden Haas Hendrix Mcgrath Bird Lucero Terrell Riggs Joyce Mercer Rollins Galloway Duke Odom Andersen Downs Hatfield Benitez Archer Huerta Travis Mcneil Hinton Zhang Hays Mayo Fritz Branch Mooney Ewing Ritter Esparza Frey Braun Gay Riddle Haney Kaiser Holder Chaney Mcknight Gamble Vang Cooley Carney Cowan Forbes Ferrell Davies Barajas Shea Osborn Bright Cuevas Bolton Murillo Lutz Duarte Kidd Key Cooke);
	return $first_names[rand @first_names] . __PACKAGE__->rand_utf8_char() . " " . $last_names[rand @last_names] . __PACKAGE__->rand_utf8_char();
}

package WWW::Shopify::Field::String::LastName;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	my @last_names = qw(Smith Johnson Williams Brown Jones Miller Davis Garcia Rodriguez Wilson Martinez Anderson Taylor Thomas Hernandez Moore Martin Jackson Thompson White Lopez Lee Gonzalez Harris Clark Lewis Robinson Walker Perez Hall Young Allen Sanchez Wright King Scott Green Baker Adams Nelson Hill Ramirez Campbell Mitchell Roberts Carter Phillips Evans Turner Torres Parker Collins Edwards Stewart Flores Morris Nguyen Murphy Rivera Cook Rogers Morgan Peterson Cooper Reed Bailey Bell Gomez Kelly Howard Ward Cox Diaz Richardson Wood Watson Brooks Bennett Gray James Reyes Cruz Hughes Price Myers Long Foster Sanders Ross Morales Powell Sullivan Russell Ortiz Jenkins Gutierrez Perry Butler Barnes Fisher Henderson Coleman Simmons Patterson Jordan Reynolds Hamilton Graham Kim Gonzales Alexander Ramos Wallace Griffin West Cole Hayes Chavez Gibson Bryant Ellis Stevens Murray Ford Marshall Owens Mcdonald Harrison Ruiz Kennedy Wells Alvarez Woods Mendoza Castillo Olson Webb Washington Tucker Freeman Burns Henry Vasquez Snyder Simpson Crawford Jimenez Porter Mason Shaw Gordon Wagner Hunter Romero Hicks Dixon Hunt Palmer Robertson Black Holmes Stone Meyer Boyd Mills Warren Fox Rose Rice Moreno Schmidt Patel Ferguson Nichols Herrera Medina Ryan Fernandez Weaver Daniels Stephens Gardner Payne Kelley Dunn Pierce Arnold Tran Spencer Peters Hawkins Grant Hansen Castro Hoffman Hart Elliott Cunningham Knight Bradley Carroll Hudson Duncan Armstrong Berry Andrews Johnston Ray Lane Riley Carpenter Perkins Aguilar Silva Richards Willis Matthews Chapman Lawrence Garza Vargas Watkins Wheeler Larson Carlson Harper George Greene Burke Guzman Morrison Munoz Jacobs Obrien Lawson Franklin Lynch Bishop Carr Salazar Austin Mendez Gilbert Jensen Williamson Montgomery Harvey Oliver Howell Dean Hanson Weber Garrett Sims Burton Fuller Soto Mccoy Welch Chen Schultz Walters Reid Fields Walsh Little Fowler Bowman Davidson May Day Schneider Newman Brewer Lucas Holland Wong Banks Santos Curtis Pearson Delgado Valdez Pena Rios Douglas Sandoval Barrett Hopkins Keller Guerrero Stanley Bates Alvarado Beck Ortega Wade Estrada Contreras Barnett Caldwell Santiago Lambert Powers Chambers Nunez Craig Leonard Lowe Rhodes Byrd Gregory Shelton Frazier Becker Maldonado Fleming Vega Sutton Cohen Jennings Parks Mcdaniel Watts Barker Norris Vaughn Vazquez Holt Schwartz Steele Benson Neal Dominguez Horton Terry Wolfe Hale Lyons Graves Haynes Miles Park Warner Padilla Bush Thornton Mccarthy Mann Zimmerman Erickson Fletcher Mckinney Page Dawson Joseph Marquez Reeves Klein Espinoza Baldwin Moran Love Robbins Higgins Ball Cortez Le Griffith Bowen Sharp Cummings Ramsey Hardy Swanson Barber Acosta Luna Chandler Blair Daniel Cross Simon Dennis Oconnor Quinn Gross Navarro Moss Fitzgerald Doyle Mclaughlin Rojas Rodgers Stevenson Singh Yang Figueroa Harmon Newton Paul Manning Garner Mcgee Reese Francis Burgess Adkins Goodman Curry Brady Christensen Potter Walton Goodwin Mullins Molina Webster Fischer Campos Avila Sherman Todd Chang Blake Malone Wolf Hodges Juarez Gill Farmer Hines Gallagher Duran Hubbard Cannon Miranda Wang Saunders Tate Mack Hammond Carrillo Townsend Wise Ingram Barton Mejia Ayala Schroeder Hampton Rowe Parsons Frank Waters Strickland Osborne Maxwell Chan Deleon Norman Harrington Casey Patton Logan Bowers Mueller Glover Floyd Hartman Buchanan Cobb French Kramer Mccormick Clarke Tyler Gibbs Moody Conner Sparks Mcguire Leon Bauer Norton Pope Flynn Hogan Robles Salinas Yates Lindsey Lloyd Marsh Mcbride Owen Solis Pham Lang Pratt Lara Brock Ballard Trujillo Shaffer Drake Roman Aguirre Morton Stokes Lamb Pacheco Patrick Cochran Shepherd Cain Burnett Hess Li Cervantes Olsen Briggs Ochoa Cabrera Velasquez Montoya Roth Meyers Cardenas Fuentes Weiss Hoover Wilkins Nicholson Underwood Short Carson Morrow Colon Holloway Summers Bryan Petersen Mckenzie Serrano Wilcox Carey Clayton Poole Calderon Gallegos Greer Rivas Guerra Decker Collier Wall Whitaker Bass Flowers Davenport Conley Houston Huff Copeland Hood Monroe Massey Roberson Combs Franco Larsen Pittman Randall Skinner Wilkinson Kirby Cameron Bridges Anthony Richard Kirk Bruce Singleton Mathis Bradford Boone Abbott Charles Allison Sweeney Atkinson Horn Jefferson Rosales York Christian Phelps Farrell Castaneda Nash Dickerson Bond Wyatt Foley Chase Gates Vincent Mathews Hodge Garrison Trevino Villarreal Heath Dalton Valencia Callahan Hensley Atkins Huffman Roy Boyer Shields Lin Hancock Grimes Glenn Cline Delacruz Camacho Dillon Parrish Oneill Melton Booth Kane Berg Harrell Pitts Savage Wiggins Brennan Salas Marks Russo Sawyer Baxter Golden Hutchinson Liu Walter Mcdowell Wiley Rich Humphrey Johns Koch Suarez Hobbs Beard Gilmore Ibarra Keith Macias Khan Andrade Ware Stephenson Henson Wilkerson Dyer Mcclure Blackwell Mercado Tanner Eaton Clay Barron Beasley Oneal Preston Small Wu Zamora Macdonald Vance Snow Mcclain Stafford Orozco Barry English Shannon Kline Jacobson Woodard Huang Kemp Mosley Prince Merritt Hurst Villanueva Roach Nolan Lam Yoder Mccullough Lester Santana Valenzuela Winters Barrera Leach Orr Berger Mckee Strong Conway Stein Whitehead Bullock Escobar Knox Meadows Solomon Velez Odonnell Kerr Stout Blankenship Browning Kent Lozano Bartlett Pruitt Buck Barr Gaines Durham Gentry Mcintyre Sloan Melendez Rocha Herman Sexton Moon Hendricks Rangel Stark Lowery Hardin Hull Sellers Ellison Calhoun Gillespie Mora Knapp Mccall Morse Dorsey Weeks Nielsen Livingston Leblanc Mclean Bradshaw Glass Middleton Buckley Schaefer Frost Howe House Mcintosh Ho Pennington Reilly Hebert Mcfarland Hickman Noble Spears Conrad Arias Galvan Velazquez Huynh Frederick Randolph Cantu Fitzpatrick Mahoney Peck Villa Michael Donovan Mcconnell Walls Boyle Mayer Zuniga Giles Pineda Pace Hurley Mays Mcmillan Crosby Ayers Case Bentley Shepard Everett Pugh David Mcmahon Dunlap Bender Hahn Harding Acevedo Raymond Blackburn Duffy Landry Dougherty Bautista Shah Potts Arroyo Valentine Meza Gould Vaughan Fry Rush Avery Herring Dodson Clements Sampson Tapia Bean Lynn Crane Farley Cisneros Benton Ashley Mckay Finley Best Blevins Friedman Moses Sosa Blanchard Huber Frye Krueger Bernard Rosario Rubio Mullen Benjamin Haley Chung Moyer Choi Horne Yu Woodward Ali Nixon Hayden Rivers Estes Mccarty Richmond Stuart Maynard Brandt Oconnell Hanna Sanford Sheppard Church Burch Levy Rasmussen Coffey Ponce Faulkner Donaldson Schmitt Novak Costa Montes Booker Cordova Waller Arellano Maddox Mata Bonilla Stanton Compton Kaufman Dudley Mcpherson Beltran Dickson Mccann Villegas Proctor Hester Cantrell Daugherty Cherry Bray Davila Rowland Levine Madden Spence Good Irwin Werner Krause Petty Whitney Baird Hooper Pollard Zavala Jarvis Holden Haas Hendrix Mcgrath Bird Lucero Terrell Riggs Joyce Mercer Rollins Galloway Duke Odom Andersen Downs Hatfield Benitez Archer Huerta Travis Mcneil Hinton Zhang Hays Mayo Fritz Branch Mooney Ewing Ritter Esparza Frey Braun Gay Riddle Haney Kaiser Holder Chaney Mcknight Gamble Vang Cooley Carney Cowan Forbes Ferrell Davies Barajas Shea Osborn Bright Cuevas Bolton Murillo Lutz Duarte Kidd Key Cooke);
	return $last_names[rand @last_names];
}

package WWW::Shopify::Field::String::FirstName;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	my @first_names = qw(James John Robert Michael William David Richard Charles Joseph Thomas Christopher Daniel Paul Mark Donald George Kenneth Steven Edward Brian Ronald Anthony Kevin Jason Matthew Gary Timothy Jose Larry Jeffrey Frank Scott Eric Stephen Andrew Raymond Gregory Joshua Jerry Dennis Walter Patrick Peter Harold Douglas Henry Carl Arthur Ryan Roger Joe Juan Jack Albert Jonathan Justin Terry Gerald Keith Samuel Willie Ralph Lawrence Nicholas Roy Benjamin Bruce Brandon Adam Harry Fred Wayne Billy Steve Louis Jeremy Aaron Randy Howard Eugene Carlos Russell Bobby Victor Martin Ernest Phillip Todd Jesse Craig Alan Shawn Clarence Sean Philip Chris Johnny Earl Jimmy Antonio Danny Bryan Tony Luis Mike Stanley Leonard Nathan Dale Manuel Rodney Curtis Norman Allen Marvin Vincent Glenn Jeffery Travis Jeff Chad Jacob Lee Melvin Alfred Kyle Francis Bradley Jesus Herbert Frederick Ray Joel Edwin Don Eddie Ricky Troy Randall Barry Alexander Bernard Mario Leroy Francisco Marcus Micheal Theodore Clifford Miguel Oscar Jay Jim Tom Calvin Alex Jon Ronnie Bill Lloyd Tommy Leon Derek Warren Darrell Jerome Floyd Leo Alvin Tim Wesley Gordon Dean Greg Jorge Dustin Pedro Derrick Dan Lewis Zachary Corey Herman Maurice Vernon Roberto Clyde Glen Hector Shane Ricardo Sam Rick Lester Brent Ramon Charlie Tyler Gilbert Gene Marc Reginald Ruben Brett Angel Nathaniel Rafael Leslie Edgar Milton Raul Ben Chester Cecil Duane Franklin Andre Elmer Brad Gabriel Ron Mitchell Roland Arnold Harvey Jared Adrian Karl Cory Claude Erik Darryl Jamie Neil Jessie Christian Javier Fernando Clinton Ted Mathew Tyrone Darren Lonnie Lance Cody Julio Kelly Kurt Allan Nelson Guy Clayton Hugh Max Dwayne Dwight Armando Felix Jimmie Everett Jordan Ian Wallace Ken Bob Jaime Casey Alfredo Alberto Dave Ivan Johnnie Sidney Byron Julian Isaac Morris Clifton Willard Daryl Ross Virgil Andy Marshall Salvador Perry Kirk Sergio Marion Tracy Seth Kent Terrance Rene Eduardo Terrence Enrique Freddie Wade Austin Hal Brain Rob Elwood Kendrick Darius Moises Son Marlin Fidel Thaddeus Cliff Marcel Ali Jackson Raphael Bryon Armand Alvaro Jeffry Dane Joesph Thurman Ned Sammie Rusty Michel Monty Rory Fabian Reggie Mason Graham Kris Isaiah Vaughn Gus Avery Loyd Diego Alexis Adolph Norris Millard Rocco Gonzalo Derick Rodrigo Gerry Stacey Carmen Wiley Rigoberto Alphonso Ty Shelby Rickie Noe Vern Bobbie Reed Jefferson Elvis Bernardo Mauricio Hiram Donovan Basil Riley Ollie Nickolas Maynard Scot Vince Quincy Eddy Sebastian Federico Ulysses Heriberto Donnell Cole Denny Davis Gavin Emery Ward Romeo Jayson Dion Dante Clement Coy Odell Maxwell Jarvis Bruno Issac Mary Dudley Brock Sanford Colby Carmelo Barney Nestor Hollis Stefan Donny Art Linwood Beau Weldon Galen Isidro Truman Delmar Johnathon Silas Frederic Dick Kirby Irwin Cruz Merlin Merrill Charley Marcelino Lane Harris Cleo Carlo Trenton Kurtis Hunter Aurelio Winfred Vito Collin Denver Carter Leonel Emory Pasquale Mohammad Mariano Danial Blair Landon Dirk Branden Adan Numbers Clair Buford German Bernie Wilmer Joan Emerson Zachery Fletcher Jacques Errol Dalton Monroe Josue Dominique Edwardo Booker Wilford Sonny Shelton Carson Theron Raymundo Daren Tristan Houston Robby Lincoln Jame Genaro Gale Bennett Octavio Cornell Laverne Hung Arron Antony Herschel Alva Giovanni Garth Cyrus Cyril Ronny Stevie Lon Freeman Erin Duncan Kennith Carmine Augustine Young Erich Chadwick Wilburn Russ Reid Myles Anderson Morton Jonas Forest Mitchel Mervin Zane Rich Jamel Lazaro Alphonse Randell Major Johnie Jarrett Brooks Ariel Abdul Dusty Luciano Lindsey Tracey Seymour Scottie Eugenio Mohammed Sandy Valentin Chance Arnulfo Lucien Ferdinand Thad Ezra Sydney Aldo Rubin Royal Mitch Earle Abe Wyatt Marquis Lanny Kareem Jamar Boris Isiah Emile Elmo Aron Leopoldo Everette Josef Gail Eloy Dorian Rodrick Reinaldo Lucio Jerrod Weston Hershel Barton Parker Lemuel Lavern Burt Jules Gil Eliseo Ahmad Nigel Efren Antwan Alden Margarito Coleman Refugio Dino Osvaldo Les Deandre Normand Kieth Ivory Andrea Trey Norberto Napoleon Jerold Fritz Rosendo Milford Sang Deon Christoper Alfonzo Lyman Josiah Brant Wilton Rico Jamaal Dewitt Carol Brenton Yong Olin Foster Faustino Claudio Judson Gino Edgardo Berry Alec Tanner Jarred Donn Trinidad Tad Shirley Prince Porfirio Odis Maria Lenard Chauncey Chang Tod Mel Marcelo Kory Augustus Keven Hilario Bud Sal Rosario Orval Mauro Dannie Zachariah Olen Anibal Milo Jed Frances Thanh Dillon Amado Newton Connie Lenny Tory Richie Lupe Horacio Brice Mohamed Delmer Dario Reyes Dee Mac Jonah Jerrold Robt Hank Sung Rupert Rolland Kenton Damion Chi Antone Waldo Fredric Bradly Quinn Kip Burl Walker Tyree Jefferey Ahmed Willy Stanford Oren Noble Moshe Mikel Enoch Brendon Quintin Jamison Florencio Darrick Tobias Minh Hassan Giuseppe Demarcus Cletus Tyrell Lyndon Keenan Werner Theo Geraldo Lou Columbus Chet Bertram Markus Huey Hilton Dwain Donte Tyron Omer Isaias Hipolito Fermin Chung Adalberto Valentine Jamey Bo Barrett Whitney Teodoro Mckinley Maximo Garfield Sol Raleigh Lawerence Abram Rashad King Emmitt Daron Chong Samual Paris Otha Miquel Lacy Eusebio Dong Domenic Darron Buster Antonia Wilber Renato Jc Hoyt Haywood Ezekiel Chas Florentino Elroy Clemente Arden Neville Kelley Edison Deshawn Carrol Shayne Nathanial Jordon Danilo Claud Val Sherwood Raymon Rayford Cristobal Ambrose Titus Hyman Felton Ezequiel Erasmo Stanton Lonny Len Ike Milan Lino Jarod Herb Andreas Walton Rhett Palmer Jude Douglass Cordell Oswaldo Ellsworth Virgilio Toney Nathanael Del Britt Benedict Mose Hong Leigh Johnson Isreal Gayle Garret Fausto Asa Arlen Zack Warner Modesto Francesco Manual Jae Gaylord Gaston Filiberto Deangelo Michale Granville Wes Malik Zackary Tuan Nicky Eldridge Cristopher Cortez Antione Malcom Long Korey Jospeh Colton Waylon Von Hosea Shad Santo Rudolf Rolf Rey Renaldo Marcellus Lucius Lesley Kristofer Boyce Benton Man Kasey Jewell Hayden Harland Arnoldo Rueben Leandro Kraig Jerrell Jeromy Hobert Cedrick Arlie Winford Wally Patricia Luigi Keneth Jacinto Graig Franklyn Edmundo Sid Porter Leif Lauren Jeramy Elisha Buck Willian Vincenzo Shon Michal Lynwood Lindsay Jewel Jere Hai Elden Dorsey Darell Broderick Alonso Stuart Fredrick Arturo Alejandro Jackie Joey Nick Luther Wendell Jeremiah Evan Julius Dana Donnie Otis Shannon Trevor Oliver Luke Homer Gerard Doug Kenny Hubert Angelo Shaun Lyle Matt Lynn Alfonso Orlando Rex Carlton Ernesto Cameron Neal Pablo Lorenzo Omar Wilbur Blake Grant Horace Roderick Kerry Abraham Willis Rickey Jean Ira Andres Cesar Johnathan Malcolm Rudolph Damon Kelvin Rudy Preston Alton Archie Marco Wm Pete Randolph Garry Geoffrey Jonathon Felipe Bennie Gerardo Ed Dominic Robin Loren Delbert Colin Guillermo Earnest Lucas Benny Noel Spencer Rodolfo Myron Edmund Garrett Salvatore Cedric Lowell Gregg Sherman Wilson Devin Sylvester Kim Roosevelt Israel Jermaine Forrest Wilbert Leland Simon Guadalupe Clark Irving Carroll Bryant Owen Rufus Woodrow Sammy Kristopher Mack Levi Marcos Gustavo Jake Lionel Marty Taylor Ellis Dallas Gilberto Clint Nicolas Laurence Ismael Orville Drew Jody Ervin Dewey Al Wilfred Josh Hugo Ignacio Caleb Tomas Sheldon Erick Frankie Stewart Doyle Darrel Rogelio Terence Santiago Alonzo Elias Bert Elbert Ramiro Conrad Pat Noah Grady Phil Cornelius Lamar Rolando Clay Percy Dexter Bradford Merle Darin Amos Terrell Moses Irvin Saul Roman Darnell Randal Tommie Timmy Darrin Winston Brendan Toby Van Abel Dominick Boyd Courtney Jan Emilio Elijah Cary Domingo Santos Aubrey Emmett Marlon Emanuel Jerald Edmond Emil Dewayne Will Otto Teddy Reynaldo Bret Morgan Jess Trent Humberto Emmanuel Stephan Louie Vicente Lamont Stacy Garland Miles Micah Efrain Billie Logan Heath Rodger Harley Demetrius Ethan Eldon Rocky Pierre Junior Freddy Eli Bryce Antoine Robbie Kendall Royce Sterling Mickey Chase Grover Elton Cleveland Dylan Chuck Damian Reuben Stan August Leonardo Jasper Russel Erwin Benito Hans Monte Blaine Ernie Curt Quentin Agustin Murray Jamal Devon Adolfo Harrison Tyson Burton Brady Elliott Wilfredo Bart Jarrod Vance Denis Damien Joaquin Harlan Desmond Elliot Darwin Ashley Gregorio Buddy Xavier Kermit Roscoe Esteban Anton Solomon Scotty Norbert Elvin Williams Nolan Carey Rod Quinton Mary Patricia Linda Barbara Elizabeth Jennifer Maria Susan Margaret Dorothy Lisa Nancy Karen Betty Helen Sandra Donna Carol Ruth Sharon Michelle Laura Sarah Kimberly Deborah Jessica Shirley Cynthia Angela Melissa Brenda Amy Anna Rebecca Virginia Kathleen Pamela Martha Debra Amanda Stephanie Carolyn Christine Marie Janet Catherine Frances Ann Joyce Diane Alice Julie Heather Teresa Doris Gloria Evelyn Jean Cheryl Mildred Katherine Joan Ashley Judith Rose Janice Kelly Nicole Judy Christina Kathy Theresa Beverly Denise Tammy Irene Jane Lori Rachel Marilyn Andrea Kathryn Louise Sara Anne Jacqueline Wanda Bonnie Julia Ruby Lois Tina Phyllis Norma Paula Diana Annie Lillian Emily Robin Peggy Crystal Gladys Rita Dawn Connie Florence Tracy Edna Tiffany Carmen Rosa Cindy Grace Wendy Victoria Edith Kim Sherry Sylvia Josephine Thelma Shannon Sheila Ethel Ellen Elaine Marjorie Carrie Charlotte Monica Esther Pauline Emma Juanita Anita Rhonda Hazel Amber Eva Debbie April Leslie Clara Lucille Jamie Joanne Eleanor Valerie Danielle Megan Alicia Suzanne Michele Gail Bertha Darlene Veronica Jill Erin Geraldine Lauren Cathy Joann Lorraine Lynn Sally Regina Erica Beatrice Dolores Bernice Audrey Yvonne Annette June Samantha Marion Dana Stacy Ana Renee Ida Vivian Roberta Holly Brittany Melanie Loretta Yolanda Jeanette Laurie Katie Kristen Vanessa Alma Sue Elsie Beth Jeanne Vicki Carla Tara Rosemary Eileen Terri Gertrude Lucy Tonya Ella Stacey Wilma Gina Kristin Jessie Natalie Agnes Vera Willie Charlene Bessie Delores Melinda Pearl Arlene Maureen Colleen Allison Tamara Joy Georgia Constance Lillie Claudia Jackie Marcia Tanya Nellie Minnie Marlene Heidi Glenda Lydia Viola Courtney Marian Stella Caroline Dora Jo Vickie Mattie Terry Maxine Irma Mabel Marsha Myrtle Lena Christy Deanna Patsy Hilda Gwendolyn Jennie Nora Margie Nina Cassandra Leah Penny Kay Priscilla Naomi Carole Brandy Olga Billie Dianne Tracey Leona Jenny Felicia Sonia Miriam Velma Becky Bobbie Violet Kristina Toni Misty Mae Shelly Daisy Ramona Sherri Erika Katrina Claire Lindsey Lindsay Geneva Guadalupe Belinda Margarita Sheryl Cora Faye Ada Natasha Sabrina Isabel Marguerite Hattie Harriet Molly Cecilia Kristi Brandi Blanche Sandy Rosie Joanna Iris Eunice Angie Inez Lynda Madeline Amelia Alberta Genevieve Monique Jodi Janie Maggie Kayla Sonya Jan Lee Kristine Candace Fannie Maryann Opal Alison Yvette Melody Luz Susie Olivia Flora Shelley Kristy Mamie Lula Lola Verna Beulah Antoinette Candice Juana Jeannette Pam Kelli Hannah Whitney Bridget Karla Celia Latoya Patty Shelia Gayle Della Vicky Lynne Sheri Marianne Kara Jacquelyn Erma Blanca Myra Leticia Pat Krista Roxanne Angelica Johnnie Robyn Francis Adrienne Rosalie Alexandra Brooke Bethany Sadie Bernadette Traci Jody Kendra Jasmine Nichole Rachael Chelsea Mable Ernestine Muriel Marcella Elena Krystal Angelina Nadine Kari Estelle Dianna Paulette Lora Mona Doreen Rosemarie Angel Desiree Antonia Hope Ginger Janis Betsy Christie Freda Mercedes Meredith Lynette Teri Cristina Eula Leigh Meghan Sophia Eloise Rochelle Gretchen Cecelia Raquel Henrietta Alyssa Jana Kelley Gwen Kerry Jenna Tricia Laverne Olive Alexis Tasha Silvia Elvira Casey Delia Sophie Kate Patti Lorena Kellie Sonja Lila Lana Darla May Mindy Essie Mandy Lorene Elsa Josefina Jeannie Miranda Dixie Lucia Marta Faith Lela Johanna Shari Camille Tami Shawna Elisa Ebony Melba Ora Nettie Tabitha Ollie Jaime Winifred Kristie Marina Alisha Aimee Rena Myrna Marla Tammie Latasha Bonita Patrice Ronda Sherrie Addie Francine Deloris Stacie Adriana Cheri Shelby Abigail Celeste Jewel Cara Adele Rebekah Lucinda Dorthy Chris Effie Trina Reba Shawn Sallie Aurora Lenora Etta Lottie Kerri Trisha Nikki Estella Francisca Josie Tracie Marissa Karin Brittney Janelle Lourdes Laurel Helene Fern Elva Corinne Kelsey Ina Bettie Elisabeth Aida Caitlin Ingrid Iva Eugenia Christa Goldie Cassie Maude Jenifer Therese Frankie Dena Lorna Janette Latonya Candy Morgan Consuelo Tamika Rosetta Debora Cherie Polly Dina Jewell Fay Jillian Dorothea Nell Trudy Esperanza Patrica Kimberley Shanna Helena Carolina Cleo Stefanie Rosario Ola Janine Mollie Lupe Alisa Lou Maribel Susanne Bette Susana Elise Cecile Isabelle Lesley Jocelyn Paige Joni Rachelle Leola Daphne Alta Ester Petra Graciela Imogene Jolene Keisha Lacey Glenna Gabriela Keri Ursula Lizzie Kirsten Shana Adeline Mayra Jayne Jaclyn Gracie Sondra Carmela Marisa Rosalind Charity Tonia Beatriz Marisol Clarice Jeanine Sheena Angeline Frieda Lily Robbie Shauna Millie Claudette Cathleen Angelia Gabrielle Autumn Katharine Summer Jodie Staci Lea Christi Jimmie Justine Elma Luella Margret Dominique Socorro Rene Martina Margo Mavis Callie Bobbi Maritza Lucile Leanne Jeannine Deana Aileen Lorie Ladonna Willa Manuela Gale Selma Dolly Sybil Abby Lara Dale Ivy Dee Winnie Marcy Luisa Jeri Magdalena Ofelia Meagan Audra Matilda Leila Cornelia Bianca Simone Bettye Randi Virgie Latisha Barbra Georgina Eliza Leann Bridgette Rhoda Haley Adela Nola Bernadine Flossie Ila Greta Ruthie Nelda Minerva Lilly Terrie Letha Hilary Estela Valarie Brianna Rosalyn Earline Catalina Ava Mia Clarissa Lidia Corrine Alexandria Concepcion Tia Sharron Rae Dona Ericka Jami Elnora Chandra Lenore Neva Marylou Melisa Tabatha Serena Avis Allie Sofia Jeanie Odessa Nannie Harriett Loraine Penelope Milagros Emilia Benita Allyson Ashlee Tania Tommie Esmeralda Karina Eve Pearlie Zelma Malinda Noreen Tameka Saundra Hillary Amie Althea Rosalinda Jordan Lilia Alana Gay Clare Alejandra Elinor Michael Lorrie Jerri Darcy Earnestine Carmella Taylor Noemi Marcie Liza Annabelle Louisa Earlene Mallory Carlene Nita Selena Tanisha Katy Julianne John Lakisha Edwina Maricela Margery Kenya Dollie Roxie Roslyn Kathrine Nanette Charmaine Lavonne Ilene Kris Tammi Suzette Corine Kaye Jerry Merle Chrystal Lina Deanne Lilian Juliana Aline Luann Kasey Maryanne Evangeline Colette Melva Lawanda Yesenia Nadia Madge Kathie Eddie Ophelia Valeria Nona Mitzi Mari Georgette Claudine Fran Alissa Roseann Lakeisha Susanna Reva Deidre Chasity Sheree Carly James Elvia Alyce Deirdre Gena Briana Araceli Katelyn Rosanne Wendi Tessa Berta Marva Imelda Marietta Marci Leonor Arline Sasha Madelyn Janna Juliette Deena Aurelia Josefa Augusta Liliana Young Christian Lessie Amalia Savannah Anastasia Vilma Natalia Rosella Lynnette Corina Alfreda Leanna Carey Amparo Coleen Tamra Aisha Wilda Karyn Cherry Queen Maura Mai Evangelina Rosanna Hallie Erna Enid Mariana Lacy Juliet Jacklyn Freida Madeleine Mara Hester Cathryn Lelia Casandra Bridgett Angelita Jannie Dionne Annmarie Katina Beryl Phoebe Millicent Katheryn Diann Carissa Maryellen Liz Lauri Helga Gilda Adrian Rhea Marquita Hollie Tisha Tamera Angelique Francesca Britney Kaitlin Lolita Florine Rowena Reyna Twila Fanny Janell Ines Concetta Bertie Alba Brigitte Alyson Vonda Pansy Elba Noelle Letitia Kitty Deann Brandie Louella Leta Felecia Sharlene Lesa Beverley Robert Isabella Herminia Terra Celina);
	return $first_names[rand @first_names];
}

package WWW::Shopify::Field::String::Address;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return ::random_regex("[1-9][0-9]{0,3}") . " " . join(" ", ::rand_words(size => 1)) . " Street";
}

package WWW::Shopify::Field::String::Postal;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return ::random_regex("[A-Z0-9]{6}");
}

package WWW::Shopify::Field::String::City;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	my @cities = qw(Aba Abeokuta Abidjan Abu Acapulco Accra Adelaide Aden Agadir Agra Aguascalientes Ahmadabad Ahvaz Ajmer al Aleppo Alexandria Algiers al al Aligarh Allahabad al Almaty al Amman Ampang Amravati Amritsar Amsterdam Ankara Ansan Anshan Antalya Antananarivo Antipolo Anyang Anyang Arak Arequipa Asansol Asgabat Asmara as Astrakhan Asunci Athens at Aurangabad Austin Baghdad Bahawalpur Baku Baltimore Bamako Bandar Bandung Bangalore Bangkok Bangui Banjarmasin Baoding Baotou Barcelona Bareli Barnaul Barquisimeto Barranquilla Bayrut Beira Bekasi Bel Belgrade Belo Bengbu Benghazi Benin Benoni Benxi Berlin Bhavnagar Bhilai Bhiwandi Bhopal Bhubaneswar Bikaner Birmingham Biskek Blantyre Bogor Bogot Bombay Boston Bouak Bras Brazzaville Bremen Brisbane Brussels Bucaramanga Bucharest Budapest Buenos Bulawayo Bursa Cairo Calcutta Calgary Cali Campinas Campo Canc Cangzhou Cape Caracas Cartagena Casablanca Cebu Chandigarh Changchun Changde Changsha Changwon Changzhi Changzhou Charlotte Chattagam Chelyabinsk Chengdu Chiba Chicago Chiclayo Chihuahua Chimalhuac Chisinau Chongju Chongqing Chonju Ciudad Cochabamba Cologne Colombo Columbus Conakry Contagem Copenhagen Cotonou Cracow Cuiab Culiac Curitiba Dakar Dalian Dallas Damascus Dandong Dar Datong Davao Dehra Delhi Denver Depok Detroit Dhaka Diyarbakir Dnipropetrovs Donetsk Dortmund Douala Dubai Dublin Duisburg Duque Durban Durgapur Dushanbe Ecatepec Edmonton El El Enugu Esfahan Eskisehir Essen Faisalabad Faridabad Fez Fortaleza Fort Foshan Frankfurt Freetown Fukuoka Funabashi Fushun Fuxin Fuzhou Gaziantep Genoa Ghaziabad Gizeh Glasgow Goi Gold Gorakhpur Guadalajara Guadalupe Guangzhou Guarulhos Guatemala Guayaquil Guilin Guiyang Gujranwala Guntur Guwahati Gwalior Hachioji Haikou Hai Hamadan Hamamatsu Hamburg Hamhung Hamilton Handan Hangzhou Ha Hanover Haora Harare Harbin Hargeysa Havanna Hefei Hegang Helsinki Hengyang Hermosillo Higashiosaka Hiroshima Ho Hohhot Houston Huaibei Huainan Huaiyin Huangshi Hubli Hyderabad Hyderabad Ibadan Ilorin Inchon Indianapolis Indore Ipoh Irbil Irkutsk Islamabad Istanbul Izhevsk Izmir Jabalpur Jaboat Jacksonville Jaipur Jakarta Jalandhar Jamnagar Jamshedpur Jerusalem Jiamusi Jiangmen Jiaozuo Jibuti Jiddah Jilin Jinan Jinzhou Jiulong Jo Jodhpur Johannesburg Johor Jos Ju Kabul Kaduna Kagoshima Kaifeng Kalyan Kampala Kano Kanpur Kaohsiung Karachi Karaj Kataka Kathmandu Kawasaki Kayseri Kazan Kerman Kermanshah Khabarovsk Kharkiv Khartoum Khulna Kiev Kigali Kingston Kinshasa Kirkuk Kisangani Kitakyushu Klang Kobe Kochi Kolhapur Kolwezi Konya Kota Koyampattur Koyang Krasnodar Krasnoyarsk Kryvyy Kuala Kuching Kumamoto Kumasi Kunming Kwangju Kyoto Lagos Lahore Lakhnau Langfang Lanzhou La La Las Leipzig Le Liaoyang Libreville Lilongwe Lima Lipetsk Lisbon Liuzhou Lom London Los Luancheng Luanda Lubumbashi Ludhiana Luoyang Lusaka Maanshan Macei Madras Madrid Madurai Maiduguri Maisuru Makasar Makhachkala Malang Managua Manaus Mandalay Manila Maoming Maputo Maracaibo Mar Marrakesh Marseille Mashhad Matola Mbuji Mecca Medan Medell Meknes Melbourne Memphis Mendoza Mersin Mexicali Mexico Milan Milwaukee Minsk Mira Mirat Mixco Mogadishu Mombasa Monrovia Monterrey Montevideo Montreal Moradabad Morelia Moscow Mudanjiang Multan Munich Mykolayiv Naberezhnyye Nagoya Nagpur Nairobi Nanchang Nanjing Nanning Nantong Naples Nashik Nashville Natal Naucalpan Navi Neijiang Newcastle New Nezahualc Niamey Niigata Ningbo Niyala Nizhniy Nouakchott Nova Novokuznetsk Novosibirsk Odesa Ogbomosho Okayama Oklahoma Omsk Onitsha Orenburg Orumiyeh Osaka Osasco Oshogbo Oslo Ottawa Ouagadougou Oyo Padang Palembang Palermo Panjin Paris Patna Pekan Peking Penza Perm Perth Peshawar Petaling Philadelphia Phnum Phoenix Pietermaritzburg Pimpri Pingdingshan Pointe Port Port Port Portland Porto Port Poznan Prague Pretoria Puchon Puebla Puente Pune Pusan Puyang Pyongyang Qingdao Qinhuangdao Qiqihar Qom Quebec Quer Quetta Quito Rabat Raipur Rajkot Rajshahi Ranchi Rangoon Rasht Rawalpindi Recife Reynosa Ribeir Riga Rio Riyadh Rome Rongcheng Rosario Rostov Rotterdam Ryazan Sagamihara Saint Saitama Sakai Salta Saltillo Salvador Samara San San San San Sangli San San San San San Santa Santiago Santiago Santiago Santo Santo Sapporo Sarajevo Saratov Sargodha Seattle Selam Semarang Sendai Sevilla Shah Shanghai Shantou Shaoguan Shaoyang Sharjah Shashi Shatian Shenyang Shenzhen Shihezi Shihung Shijiazhuang Shiliguri Shiraz Shizuoka Sholapur Shubra Singapore Siping Sofia Sokoto Songnam Sorocaba Soul Soweto Srinagar Stockholm Stuttgart Subang Surabaya Surakarta Surat Suwon Suzhou Sydney Tabriz Taegu Taejon Taian Taichung Tainan Taipei Taiyuan Taizhou Ta Tangerang Tanggu Tangier Tangshan Tashkent Tbilisi Tegucigalpa Tehran Tembisa Teresina Thana Thiruvananthapuram Tianjin Tijuana Tiruchchirappalli Tlalnepantla Tlaquepaque Tokyo Toluca Tolyatti Toronto Torre Tripoli Trujillo Tucson Tucum Tunis Turin Tyumen Uberl Ufa Uijongbu Ulaanbaatar Ulhasnagar Ulsan Ulyanovsk Umm Urumqi Vadodara Valencia Valencia Vancouver Varanasi Veracruz Vienna Vijayawada Vilnius Visakhapatnam Vladivostok Volgograd Voronezh Wahran Warangal Warri Warsaw Washington Wenzhou Winnipeg Wroclaw Wuhan Wuhu Wuxi Xiamen Xian Xianggangdao Xiangtan Xianyang Xingtai Xining Xinxiang Xinyang Xuzhou Yancheng Yangzhou Yantai Yaound Yaroslavl Yazd Yekaterinburg Yerevan Yingkou Yogyakarta Yokohama Yuanlong Yueyang Zagreb Zahedan Zapopan Zaporizhzhya Zaragoza Zaria Zhangdian Zhangjiakou Zhangzhou Zhanjiang Zhengzhou Zhenjiang Zhuhai Zhunmen Zhuzhou Zigong);
	return $cities[int(rand(int(@cities)))];
}

package WWW::Shopify::Field::String::Province;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	my @provinces = ("Quebec", "Ontario", "Alberta", "British Columbia", "Sasakatchewan", "Manitoba", "New Brunswick", "Newfoundland & Labrador", "Northwest Territories", "Nunvavut", "Nova Scotia", "Prince Edward Island", "Yukon Territory", "Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming", "District of Columbia", "Puerto Rico", "Guam", "American Samoa", "U.S. Virgin Islands", "Northern Mariana Islands");
	return $provinces[int(rand(int(@provinces)))];
}

package WWW::Shopify::Field::String::Country;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	my @countries = ("Aland Islands", "Albania", "Algeria", "Andorra", "Angola", "Anguilla", "Antigua And Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia And Herzegovina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Virgin Islands, British", "Brunei", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Republic of Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Congo, The Democratic Republic Of The", "Cook Islands", "Costa Rica", "Croatia", "Cuba", "Curaçao", "Cyprus", "Czech Republic", "Côte d'Ivoire", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guatemala", "Guernsey", "Guinea", "Guinea Bissau", "Guyana", "Haiti", "Heard Island And Mcdonald Islands", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Iran, Islamic Republic Of", "Iraq", "Ireland", "Isle Of Man", "Israel", "Italy", "Jamaica", "Japan", "Jersey", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Kosovo", "Kuwait", "Kyrgyzstan", "Lao People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macao", "Macedonia, Republic Of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Moldova, Republic of", "Monaco", "Mongolia", "Montenegro", "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Korea, Democratic People's Republic Of", "Norway", "Oman", "Pakistan", "Palestinian Territory, Occupied", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Qatar", "Reunion", "Romania", "Russia", "Rwanda", "Samoa", "San Marino", "Sao Tome And Principe", "Saudi Arabia", "Senegal", "Serbia", "Seychelles", "Sierra Leone", "Singapore", "Sint Maarten", "Slovakia", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia And The South Sandwich Islands", "South Korea", "Spain", "Sri Lanka", "Saint Barthélemy", "Saint Helena", "Saint Kitts And Nevis", "Saint Lucia", "Saint Martin", "Saint Pierre And Miquelon", "St. Vincent", "Sudan", "Suriname", "Svalbard And Jan Mayen", "Swaziland", "Sweden", "Switzerland", "Syria", "Taiwan", "Tajikistan", "Tanzania, United Republic Of", "Thailand", "Timor Leste", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "United States Minor Outlying Islands", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "Uruguay", "Uzbekistan", "Vanuatu", "Holy See (Vatican City State)", "Venezuela", "Vietnam", "Wallis And Futuna", "Western Sahara", "Yemen", "Zambia", "Zimbabwe");
	return $countries[int(rand(int(@countries)))];
}

package WWW::Shopify::Field::String::Phone;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return ::random_regex('\d{1,2} \d{3} \d{3}-\d{4}');		
}

package WWW::Shopify::Field::String::Handle;
use parent 'WWW::Shopify::Field::String';

sub sql_type { return "varchar(255)"; }

sub generate($) {
	my $string = lc(join("-", ::rand_words(size => int(rand(2))+2)));
	$string =~ s/[^a-z\-]//g;
	return $string;
}

package WWW::Shopify::Field::String::Hostname;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return ::random_regex("[a-z\_0-9]{3,24}") . ".com";
}

package WWW::Shopify::Field::String::Hostname::Shopify;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return lc(WWW::Shopify::Field::String::LastName->generate) . "-" . lc(WWW::Shopify::Field::String::LastName->generate) . ::random_regex("[0-9]{4}") . ".myshopify.com";
}

package WWW::Shopify::Field::String::IPAddress;
use parent 'WWW::Shopify::Field::String';

sub generate($) {
	return join(".", (int(rand(256)), int(rand(256)), int(rand(256)), int(rand(256))));
}

package WWW::Shopify::Field::String::Enum;
use parent 'WWW::Shopify::Field::String';
use List::Util qw(first);
sub generate($) { return $_[0]->{arguments}->[0]->[int(rand(int(@{$_[0]->{arguments}->[0]})))]; }
sub validate($) { return (defined first { $_ eq $_[1] } @{$_[0]->{arguments}}); }
sub values { return @{$_[0]->{arguments}} }

package WWW::Shopify::Field::String::Custom;
use parent 'WWW::Shopify::Field::String';

sub generate($) { return $_[0]->{arguments}->[0]($_[0]); }

package WWW::Shopify::Field::String::HTML;
use parent 'WWW::Shopify::Field::String';

package WWW::Shopify::Field::String::Hex32;
use parent 'WWW::Shopify::Field::String';

sub generate {
	return ::random_regex("[a-f0-9]{32}");
}

package WWW::Shopify::Field::String::ProvinceCode;
use parent 'WWW::Shopify::Field::String';

sub generate {
	return ::random_regex("[A-Z]{2}");
}

package WWW::Shopify::Field::String::CountryCode;
use parent 'WWW::Shopify::Field::String';

sub generate {
	return ::random_regex("[A-Z]{3}");
}

package WWW::Shopify::Field::String::Zip;
use parent 'WWW::Shopify::Field::String';

sub generate {
	return ::random_regex("[A-Z]{5,6}");
}

1;

