#!perl
use strict;
use utf8;
use Test::Most;
use List::Util 1.29 qw/pairs/;

use Test::More skip_all => "Not yet ready (and not yet used, #1 in progress)";

binmode(STDOUT, 'utf8');

BEGIN { use_ok('Passwd::Keyring::OSXKeychain::PasswordTranslate', qw(read_security_encoded_passwd)); }

my @PLAINTEXT_SAMPLES = (
    'alabela', '1997', 'Koszmarny Karolek', 'fefe', 'alternatywa', '',
   );

foreach my $plain_password (@PLAINTEXT_SAMPLES) {
    is( read_security_encoded_passwd($plain_password), $plain_password, "plain: $plain_password");
}

my @ESCAPED_SAMPLES = (
    "€uro" => 'ffffffe2ffffff82ffffffac75726f0a3231333469396b6f70',
    "∑sum" => 'ffffffe2ffffff88ffffff9173756d0a3231333469396b6f70',
    "x123x" => '6b6f706f707070006b6f70006f7000700070',
    "ü∑bér" => "c3bce2ffffff88ffffff9162ffffffc3ffffffa9720a3231333469396b6f70006f7000700070",
    "¥€N" => "ffffffc2ffffffa5ffffffe2ffffff82ffffffac4e",
    "abccccccccdddddeeefffffffggggghhhhhïìjjklllmñ" => "6162636363636363636364646464646565656666666666666667676767676868686868ffffffc3ffffffafffffffc3ffffffac6a6a6b6c6c6c6dffffffc3ffffffb1",
);

foreach my $pair (pairs @ESCAPED_SAMPLES) {
    my ($utf, $escaped) = @$pair;
    print STDERR read_security_encoded_passwd($escaped), "\n";
    is( read_security_encoded_passwd($escaped), $utf, "escaped: $escaped");
}

done_testing;
