package Locale::Country::Geo;

use warnings;
use strict;

=head1 NAME

Locale::Country::Geo - Module for country geographic location data

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

    use Locale::Country::Geo;
    my ($lat, $lon) = Locale::Country::Geo->geolocation('tw');

=head1 DESCRIPTION

The information are from google's geocoding service.  You can obtain
the data by running F<scripts/reload.pl>.

=cut

use Carp ();
use YAML::Syck ();
my $DATA;
{
    local $/;
    $DATA = YAML::Syck::Load(<DATA>);
}

=head1 METHODS

=head2 geolocation

=cut

sub geolocation {
    my $class = shift;
    my $code  = shift;

    Carp::croak "Unknown country code: $code"
        unless exists $DATA->{$code};

    return @{$DATA->{$code}};
}

=head1 AUTHOR

clkao, C<< <clkao at clkao.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-locale-country-geo at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Locale-Country-Geo>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Locale::Country::Geo

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Locale-Country-Geo>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Locale-Country-Geo>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Locale-Country-Geo>

=item * Search CPAN

L<http://search.cpan.org/dist/Locale-Country-Geo>

=back

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright 2007 clkao, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Locale::Country::Geo
__DATA__
--- 
ad: 
  - 40.975439
  - -0.443657
ae: 
  - 23.424076
  - 53.847818
af: 
  - 33.939110
  - 67.709953
ag: 
  - 17.060816
  - -61.796428
ai: 
  - 18.220554
  - -63.068615
al: 
  - 41.153332
  - 20.168331
am: 
  - 40.069099
  - 45.038189
an: 
  - 12.226079
  - -69.060087
ao: 
  - -11.202692
  - 17.873887
aq: 
  - -77.550000
  - 166.400000
ar: 
  - -38.416097
  - -63.616672
as: 
  - -14.270972
  - -170.132217
at: 
  - 47.516231
  - 14.550072
au: 
  - -25.274398
  - 133.775136
aw: 
  - 12.521110
  - -69.968338
ax: 
  - 60.184534
  - 20.164776
az: 
  - 40.143105
  - 47.576927
ba: 
  - 43.915886
  - 17.679076
bb: 
  - 13.193887
  - -59.543198
bd: 
  - 23.684994
  - 90.356331
be: 
  - 50.503887
  - 4.469936
bf: 
  - 12.238333
  - -1.561593
bg: 
  - 42.733883
  - 25.485830
bh: 
  - 25.930414
  - 50.637772
bi: 
  - -3.373056
  - 29.918886
bj: 
  - 9.307690
  - 2.315834
bm: 
  - 32.321384
  - -64.757370
bn: 
  - 4.535277
  - 114.727669
bo: 
  - -16.290154
  - -63.588653
br: 
  - -14.235004
  - -51.925280
bs: 
  - 23.922220
  - -75.858200
bt: 
  - 27.514162
  - 90.433601
bv: 
  - -54.423199
  - 3.413194
bw: 
  - -22.328474
  - 24.684866
by: 
  - 53.709807
  - 27.953389
bz: 
  - 17.189877
  - -88.497650
ca: 
  - 56.130366
  - -106.346771
cc: 
  - -12.139748
  - 96.874367
cd: 
  - -4.034789
  - 21.756271
cf: 
  - 6.611111
  - 20.939444
cg: 
  - -0.228021
  - 15.827659
ch: 
  - 46.818188
  - 8.227512
ci: 
  - 7.539989
  - -5.547080
ck: 
  - -21.236736
  - -159.777671
cl: 
  - -35.675147
  - -71.542969
cm: 
  - 7.369722
  - 12.354722
cn: 
  - 35.861660
  - 104.195397
co: 
  - 4.570868
  - -74.297333
cr: 
  - 9.748917
  - -83.753428
cs: 
  - 44.015194
  - 20.729164
cu: 
  - 21.521757
  - -77.781167
cv: 
  - 16.002082
  - -24.013197
cx: 
  - -10.447525
  - 105.690449
cy: 
  - 35.126413
  - 33.429859
cz: 
  - 49.817492
  - 15.472962
de: 
  - 51.165691
  - 10.451526
dj: 
  - 11.825138
  - 42.590275
dk: 
  - 56.263920
  - 9.501785
dm: 
  - 15.414999
  - -61.370976
do: 
  - 18.735693
  - -70.162651
dz: 
  - 28.033886
  - 1.659626
ec: 
  - -1.831239
  - -78.183406
ee: 
  - 58.595272
  - 25.013607
eg: 
  - 26.820553
  - 30.802498
eh: 
  - 24.215527
  - -12.885834
er: 
  - 15.179384
  - 39.782334
es: 
  - 40.463667
  - -3.749220
et: 
  - 9.145000
  - 40.489673
fi: 
  - 61.924110
  - 25.748151
fj: 
  - -16.578193
  - 179.414413
fk: 
  - -51.957763
  - -59.528839
fm: 
  - 0
  - 0
fo: 
  - 61.892635
  - -6.911806
fr: 
  - 46.227638
  - 2.213749
fx: 
  - 0
  - 0
ga: 
  - -0.803689
  - 11.609444
gb: 
  - 55.378051
  - -3.435973
gd: 
  - 12.262776
  - -61.604171
ge: 
  - 32.678275
  - -83.222785
gf: 
  - 3.933889
  - -53.125782
gh: 
  - 7.946527
  - -1.023194
gi: 
  - 36.139999
  - -5.349999
gl: 
  - 71.706936
  - -42.604303
gm: 
  - 13.443182
  - -15.310139
gn: 
  - 9.945587
  - -9.696645
gp: 
  - 16.995971
  - -62.067641
gq: 
  - 1.650801
  - 10.267895
gr: 
  - 39.074208
  - 21.824312
gs: 
  - -54.429579
  - -36.587909
gt: 
  - 14.630000
  - -90.550003
gu: 
  - 13.444304
  - 144.793731
gw: 
  - 11.803749
  - -15.180413
gy: 
  - 4.860416
  - -58.930180
hk: 
  - 22.283300
  - 114.150001
hm: 
  - -53.081810
  - 73.504158
hn: 
  - 15.199999
  - -86.241905
hr: 
  - 44.466244
  - 16.461248
ht: 
  - 18.971187
  - -72.285215
hu: 
  - 47.162494
  - 19.503304
id: 
  - -0.789275
  - 113.921327
ie: 
  - 53.412910
  - -8.243890
il: 
  - 31.046051
  - 34.851612
in: 
  - 20.593684
  - 78.962880
io: 
  - -6.343194
  - 71.876519
iq: 
  - 33.223191
  - 43.679291
ir: 
  - 0
  - 0
is: 
  - 64.963051
  - -19.020835
it: 
  - 41.871940
  - 12.567380
jm: 
  - 18.109581
  - -77.297508
jo: 
  - 30.585164
  - 36.238414
jp: 
  - 36.204824
  - 138.252924
ke: 
  - -0.023559
  - 37.906193
kg: 
  - 41.204380
  - 74.766098
kh: 
  - 12.565679
  - 104.990963
ki: 
  - -3.370417
  - -168.734039
km: 
  - -11.875001
  - 43.872219
kn: 
  - 17.357822
  - -62.782998
kp: 
  - 1.305044
  - 103.886178
kr: 
  - 50.099479
  - 14.408868
kw: 
  - 29.311660
  - 47.481766
ky: 
  - 19.513469
  - -80.566956
kz: 
  - 48.019573
  - 66.923684
la: 
  - 19.856270
  - 102.495496
lb: 
  - 33.854721
  - 35.862285
lc: 
  - 16.845065
  - -24.982589
li: 
  - 47.166000
  - 9.555373
lk: 
  - 7.873054
  - 80.771797
lr: 
  - 6.428055
  - -9.429499
ls: 
  - -29.609988
  - 28.233608
lt: 
  - 55.169438
  - 23.881275
lu: 
  - 49.619998
  - 6.119999
lv: 
  - 56.879635
  - 24.603189
ly: 
  - 26.335100
  - 17.228331
ma: 
  - 31.791702
  - -7.092620
mc: 
  - 43.750298
  - 7.412841
md: 
  - 0
  - 0
mg: 
  - -18.766947
  - 46.869107
mh: 
  - 7.131474
  - 171.184478
mk: 
  - 59.333024
  - 18.085961
ml: 
  - 17.570692
  - -3.996166
mm: 
  - 21.913965
  - 95.956223
mn: 
  - 46.862496
  - 103.846656
mo: 
  - 22.198745
  - 113.543873
mp: 
  - 17.330830
  - 145.384690
mq: 
  - 14.641528
  - -61.024174
mr: 
  - 21.007890
  - -10.940835
ms: 
  - 16.742498
  - -62.187366
mt: 
  - 35.937496
  - 14.375416
mu: 
  - -20.348404
  - 57.552152
mv: 
  - 3.202778
  - 73.220680
mw: 
  - -13.254308
  - 34.301525
mx: 
  - 23.634501
  - -102.552784
my: 
  - 4.210484
  - 101.975766
mz: 
  - -18.665695
  - 35.529562
na: 
  - -22.957640
  - 18.490410
nc: 
  - -20.904305
  - 165.618042
ne: 
  - 17.607789
  - 8.081666
nf: 
  - -29.040835
  - 167.954712
ng: 
  - 9.081999
  - 8.675277
ni: 
  - 12.865416
  - -85.207229
nl: 
  - 52.132633
  - 5.291266
no: 
  - 60.472024
  - 8.468946
np: 
  - 28.394857
  - 84.124008
nr: 
  - -0.522778
  - 166.931503
nu: 
  - -19.054445
  - -169.867233
nz: 
  - -40.900557
  - 174.885971
om: 
  - 21.512583
  - 55.923255
pa: 
  - 8.970000
  - -79.529998
pe: 
  - -9.189967
  - -75.015152
pf: 
  - -17.679742
  - -149.406843
pg: 
  - -6.314993
  - 143.955550
ph: 
  - 12.879721
  - 121.774017
pk: 
  - 30.375321
  - 69.345116
pl: 
  - 51.919438
  - 19.145136
pm: 
  - 46.941936
  - -56.271110
pn: 
  - 40.408126
  - -79.778725
pr: 
  - 18.220833
  - -66.590149
ps: 
  - 0
  - 0
pt: 
  - 39.399872
  - -8.224454
pw: 
  - 6.510832
  - 133.433594
py: 
  - -23.442503
  - -58.443832
qa: 
  - 25.354826
  - 51.183884
re: 
  - -21.115141
  - 55.536384
ro: 
  - 45.943161
  - 24.966760
ru: 
  - 61.524010
  - 105.318756
rw: 
  - -1.940278
  - 29.873888
sa: 
  - 23.885942
  - 45.079162
sb: 
  - -9.645710
  - 160.156194
sc: 
  - -4.679574
  - 55.491977
sd: 
  - 12.862807
  - 30.217636
se: 
  - 60.128161
  - 18.643501
sg: 
  - 1.299999
  - 103.849998
sh: 
  - -24.143474
  - -10.030696
si: 
  - 46.151241
  - 14.995463
sj: 
  - 0
  - 0
sk: 
  - 48.669026
  - 19.699024
sl: 
  - 8.460555
  - -11.779889
sm: 
  - 43.939998
  - 12.430000
sn: 
  - 14.497401
  - -14.452362
so: 
  - 5.152149
  - 46.199616
sr: 
  - 3.919305
  - -56.027783
st: 
  - 0.186360
  - 6.613081
sv: 
  - 13.794185
  - -88.896530
sy: 
  - 34.802075
  - 38.996815
sz: 
  - -26.522503
  - 31.465866
tc: 
  - 21.694025
  - -71.797928
td: 
  - 15.454166
  - 18.732207
tf: 
  - -49.449960
  - 70.024982
tg: 
  - 8.619543
  - 0.824782
th: 
  - 15.870032
  - 100.992541
tj: 
  - 38.861034
  - 71.276093
tk: 
  - -8.967363
  - -171.855881
tl: 
  - -8.874217
  - 125.727539
tm: 
  - 38.969719
  - 59.556278
tn: 
  - 33.886917
  - 9.537499
to: 
  - -21.178986
  - -175.198242
tr: 
  - 38.963745
  - 35.243322
tt: 
  - 10.691803
  - -61.222503
tv: 
  - -7.109535
  - 177.649330
tw: 
  - 23.697810
  - 120.960515
tz: 
  - -6.368216
  - 34.885195
ua: 
  - 48.379433
  - 31.165580
ug: 
  - 1.373333
  - 32.290275
um: 
  - 0.000000
  - 0.000000
us: 
  - 37.090240
  - -95.712891
uy: 
  - -32.522779
  - -55.765835
uz: 
  - 41.377491
  - 64.585262
va: 
  - 0
  - 0
vc: 
  - 12.984305
  - -61.287228
ve: 
  - 6.423750
  - -66.589730
vg: 
  - 18.534979
  - -64.560630
vi: 
  - 18.498294
  - -64.366543
vn: 
  - 14.058324
  - 108.277199
vu: 
  - -15.376706
  - 166.959158
wf: 
  - -13.768752
  - -177.156097
ws: 
  - -13.759029
  - -172.104629
ye: 
  - 15.552727
  - 48.516388
yt: 
  - -12.827500
  - 45.166244
za: 
  - -30.559482
  - 22.937506
zm: 
  - -13.133897
  - 27.849332
zw: 
  - -19.015438
  - 29.154857
