#!perl
use strict;
use Test::More (tests => 61);
BEGIN
{
    use_ok("DateTime::Format::Japanese");
}

my @params = (
    [
        "ʿǯ",
        DateTime->new(year => 2004, month => 1, day => 3)
    ],
    [
        "ʿǯ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5)
    ],
    [
        "ʿǯʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5, minute => 30)
    ],
    [
        "ʿǯʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5, minute => 30, second => 29)
    ],
    [
        "ʿǯ壵ʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 17, minute => 30, second => 29)
    ],
    [
        "ʿǯ壵ʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 17, minute => 30, second => 29)
    ],
    [
        "ʿϻǯ",
        DateTime->new(year => 2004, month => 1, day => 3)
    ],
    [
        "ʿϻǯ޻",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5)
    ],
    [
        "ʿϻǯ޻ʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5, minute => 30)
    ],
    [
        "ʿϻǯ޻ʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5, minute => 30, second => 29)
    ],
    [
        "ʿϻǯ޻ʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 17, minute => 30, second => 29)
    ],
    [
        "ʿ16ǯ13",
        DateTime->new(year => 2004, month => 1, day => 3)
    ],
    [
        "ʿ16ǯ135",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5)
    ],
    [
        "ʿ16ǯ13530ʬ",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5, minute => 30)
    ],
    [
        "ʿ16ǯ13530ʬ29",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 5, minute => 30, second => 29)
    ],
    [
        "ʿ16ǯ13530ʬ29",
        DateTime->new(year => 2004, month => 1, day => 3, hour => 17, minute => 30, second => 29)
    ],
    [
        "1989ǯ37",
        DateTime->new(year => 1989, month => 3, day => 7)
    ],
    [
        "1989ǯ3713",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13)
    ],
    [
        "1989ǯ371337ʬ",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13, minute => 37)
    ],
    [
        "1989ǯ371337ʬ18",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13, minute => 37, second => 18)
    ],
    [
        "Ȭǯ",
        DateTime->new(year => 1989, month => 3, day => 7)
    ],
    [
        "Ȭǯ컰",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13)
    ],
    [
        "Ȭǯ컰ʬ",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13, minute => 37)
    ],
    [
        "Ȭǯ컰ʬȬ",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13, minute => 37, second => 18)
    ],
    [
        "1989ǯ371337ʬ18",
        DateTime->new(year => 1989, month => 3, day => 7, hour => 13, minute => 37, second => 18)
    ],
    [
        "1989ǯ37",
        DateTime->new(year => -1989, month => 3, day => 7)
    ],
    [
        "1989ǯ3713",
        DateTime->new(year => -1989, month => 3, day => 7, hour => 13)
    ],
    [
        "1989ǯ371337ʬ",
        DateTime->new(year => -1989, month => 3, day => 7, hour => 13, minute => 37)
    ],
    [
        "1989ǯ371337ʬ18",
        DateTime->new(year => -1989, month => 3, day => 7, hour => 13, minute => 37, second => 18)
    ],
    [
        "1989ǯ371337ʬ18",
        DateTime->new(year => -1989, month => 3, day => 7, hour => 13, minute => 37, second => 18)
    ],
);

my $dt;
foreach my $param (@params) {
    $dt = eval { DateTime::Format::Japanese->parse_datetime($param->[0]) };
    ok($dt);
    SKIP:{
        skip("parse_datetime raised exception or didn't return a DateTime object: $@", 1) if !$dt;
        is( $dt->compare($param->[1]), 0, "Test parse_datetime($param->[0]) = " . $param->[1]->datetime);
    }
}


