# Generated by default/object.tt
package Paws::SecurityHub::CustomDataIdentifiersResult;
  use Moose;
  has Detections => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::CustomDataIdentifiersDetections]');
  has TotalCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::CustomDataIdentifiersResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::CustomDataIdentifiersResult object:

  $service_obj->Method(Att1 => { Detections => $value, ..., TotalCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::CustomDataIdentifiersResult object:

  $result = $service_obj->Method(...);
  $result->Att1->Detections

=head1 DESCRIPTION

Contains an instance of sensitive data that was detected by a
customer-defined identifier.

=head1 ATTRIBUTES


=head2 Detections => ArrayRef[L<Paws::SecurityHub::CustomDataIdentifiersDetections>]

The list of detected instances of sensitive data.


=head2 TotalCount => Int

The total number of occurrences of sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

