
#ifdef _ASC_WITH_HELP_
//#include "cxcconfig.h"
#include "AhelpInterface.hh"
#include "AhelpPager.hh"
//#include "Pager.hh"
#else
#include <cstring>
#include <cstdlib>
#include <cstdio>

using std::strlen;
using std::sprintf;
using std::system;

#endif



#define CONTEXT_OF_PARAMLOOKUP  "tools"
#define PARAM_LOOKUP_BLOCK      "PARAM"


extern "C"
{
  int paramHelpFunction (char *tool, char *parameter, char *specific);
  
}

int paramHelpFunction (char *tool, char *parameter, char *specific)
{
  char helpString[200];
  
  if ((NULL == tool) || (strlen (tool) == 0))
    return (0);
  
  if (specific && (specific[0] == '?'))
    {
#ifdef _ASC_WITH_HELP_
      AhelpStrings err;
      AhelpStringsList optionsList;
      
      optionsList.Append (specific+1);
      GlobalAhelpInterface::GetHelp (optionsList, err);
      if (!err.isEmpty ())
	{
	  cout << err.chars () << endl;
	};
#else
      sprintf (helpString, "ahelp %s", specific + 1);
      system (helpString);
      
      
#endif
    }
  else
    {
#ifdef _ASC_WITH_HELP_
      AhelpStrings mess;
      AhelpStringsList optionsList;
      
      optionsList.Append ("-b");
      optionsList.Append (PARAM_LOOKUP_BLOCK);
      optionsList.Append ("-t");
      optionsList.Append (parameter);
      optionsList.Append (tool);
      
      GlobalAhelpInterface::GetHelp (optionsList, mess);
      
      if (!mess.isEmpty ())
	{
	  cout << endl << mess.chars () << endl;
	};
#else
      
      sprintf (helpString, "ahelp -b %s -t %s %s",
	       PARAM_LOOKUP_BLOCK, parameter, tool);
      system (helpString);
            
#endif
      
      
      
    }
  return (0);
  
  
}


