#!/usr/bin/perl

package eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMyeBayRemindersResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersResponseType

=head1 DESCRIPTION

Returns totals of various reminder types from the user's My eBay account.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMyeBayReminders::GetMyeBayRemindersResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::RemindersType;


my @gaProperties = ( [ 'BuyingReminders', 'ns:RemindersType', ''
	     ,'eBay::API::XML::DataType::RemindersType', '1' ]
	, [ 'SellingReminders', 'ns:RemindersType', ''
	     ,'eBay::API::XML::DataType::RemindersType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBuyingReminders()

Contains the buying reminders in the user's My eBay account that match
the request criteria.

#    Argument: 'ns:RemindersType'

=cut

sub setBuyingReminders {
  my $self = shift;
  $self->{'BuyingReminders'} = shift
}

=head2 getBuyingReminders()

  Returned: Conditionally
#    Returns: 'ns:RemindersType'

=cut

sub getBuyingReminders {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyingReminders'
		,'eBay::API::XML::DataType::RemindersType');
}


=head2 setSellingReminders()

Contains the selling reminders in the user's My eBay account that match
the request criteria.

#    Argument: 'ns:RemindersType'

=cut

sub setSellingReminders {
  my $self = shift;
  $self->{'SellingReminders'} = shift
}

=head2 getSellingReminders()

  Returned: Conditionally
#    Returns: 'ns:RemindersType'

=cut

sub getSellingReminders {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellingReminders'
		,'eBay::API::XML::DataType::RemindersType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
