# Generated by default/object.tt
package Paws::AccessAnalyzer::Configuration;
  use Moose;
  has IamRole => (is => 'ro', isa => 'Paws::AccessAnalyzer::IamRoleConfiguration', request_name => 'iamRole', traits => ['NameInRequest']);
  has KmsKey => (is => 'ro', isa => 'Paws::AccessAnalyzer::KmsKeyConfiguration', request_name => 'kmsKey', traits => ['NameInRequest']);
  has S3Bucket => (is => 'ro', isa => 'Paws::AccessAnalyzer::S3BucketConfiguration', request_name => 's3Bucket', traits => ['NameInRequest']);
  has SecretsManagerSecret => (is => 'ro', isa => 'Paws::AccessAnalyzer::SecretsManagerSecretConfiguration', request_name => 'secretsManagerSecret', traits => ['NameInRequest']);
  has SqsQueue => (is => 'ro', isa => 'Paws::AccessAnalyzer::SqsQueueConfiguration', request_name => 'sqsQueue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::Configuration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::Configuration object:

  $service_obj->Method(Att1 => { IamRole => $value, ..., SqsQueue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::Configuration object:

  $result = $service_obj->Method(...);
  $result->Att1->IamRole

=head1 DESCRIPTION

Access control configuration structures for your resource. You specify
the configuration as a type-value pair. You can specify only one type
of access control configuration.

=head1 ATTRIBUTES


=head2 IamRole => L<Paws::AccessAnalyzer::IamRoleConfiguration>

The access control configuration is for an IAM role.


=head2 KmsKey => L<Paws::AccessAnalyzer::KmsKeyConfiguration>

The access control configuration is for a KMS key.


=head2 S3Bucket => L<Paws::AccessAnalyzer::S3BucketConfiguration>

The access control configuration is for an Amazon S3 Bucket.


=head2 SecretsManagerSecret => L<Paws::AccessAnalyzer::SecretsManagerSecretConfiguration>

The access control configuration is for a Secrets Manager secret.


=head2 SqsQueue => L<Paws::AccessAnalyzer::SqsQueueConfiguration>

The access control configuration is for an SQS queue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

