#-*-cperl-*-
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#########################

use Test::More;

use warnings;
use strict;

use lib qw( ../../lib ../lib lib ); #Just in case we are testing it in-place

use Algorithm::Evolutionary::Utils qw(random_bitstring);

use_ok( "Algorithm::Evolutionary::Fitness::Knapsack", "using A::E::Fitness::Knapsack OK" );

#Weights and profits. Created with a generator
my @profits=(13.76, 8.40465, 7.06637, 14.066, 6.92841, 13.0597, 8.08657, 9.78078, 7.69908, 11.3133, 11.5659, 9.03571, 14.9824, 9.77511, 6.96194, 12.4665, 14.5813, 9.76035, 10.4337, 11.443, 12.8197, 10.4104, 14.1428, 7.15892, 10.8211, 7.30107, 7.86628, 13.6623, 13.9867, 9.20923, 14.1644, 12.7467, 11.6139, 6.23077, 11.8127, 12.5423, 13.2904, 13.8993, 7.32306, 14.9895, 10.2125, 12.889, 9.02522, 10.195, 7.66411, 9.98717, 7.66147, 7.24539, 13.7475, 12.0952, 12.6883, 11.5672, 7.50556, 11.8312, 12.7261, 12.3267, 13.1322, 14.5924, 10.989, 12.119, 8.80165, 10.1534, 9.86563, 14.4155, 10.3842, 6.67835, 11.9578, 8.67458, 14.5776, 13.2809, 8.66409, 9.79018, 11.1699, 11.6893, 13.9851, 12.834, 6.67648, 6.64661, 14.0794, 14.424, 12.7418, 11.7677, 10.9912, 14.2473, 8.59888, 8.71733, 11.574, 6.73112, 8.30974, 7.56303, 12.8501, 11.1114, 11.7164, 7.71571, 10.5269, 7.10056, 8.39405, 7.48473, 9.77514, 7.97168 );
my @weights=(8.75995, 3.40465, 2.06637, 9.06605, 1.92841, 8.05966, 3.08657, 4.78078, 2.69908, 6.31326, 6.56593, 4.03571, 9.98242, 4.77511, 1.96194, 7.46651, 9.58128, 4.76035, 5.4337, 6.44295, 7.8197, 5.41039, 9.14283, 2.15892, 5.82114, 2.30107, 2.86628, 8.66228, 8.98672, 4.20923, 9.1644, 7.74667, 6.61388, 1.23077, 6.81272, 7.54229, 8.29043, 8.89928, 2.32306, 9.98951, 5.21255, 7.889, 4.02522, 5.19496, 2.66411, 4.98716, 2.66147, 2.24539, 8.74751, 7.09517, 7.68834, 6.56721, 2.50556, 6.83117, 7.72613, 7.3267, 8.13224, 9.59241, 5.98898, 7.11896, 3.80165, 5.15338, 4.86563, 9.41553, 5.38415, 1.67835, 6.95782, 3.67458, 9.57763, 8.28088, 3.66409, 4.79018, 6.16987, 6.68932, 8.98514, 7.83398, 1.67648, 1.64661, 9.07937, 9.42399, 7.74178, 6.76771, 5.9912, 9.24734, 3.59888, 3.71733, 6.57405, 1.73112, 3.30974, 2.56303, 7.85008, 6.11139, 6.71641, 2.71571, 5.52692, 2.10056, 3.39405, 2.48473, 4.77514, 2.97168 );

my $Nmax=100;  #Max. number of elements to choose
my $capacity=286; #Max. Capacity of the knapsack
my $rho=5.0625; #Penalizations coeficient

my $knap = new Algorithm::Evolutionary::Fitness::Knapsack( $Nmax, $capacity, $rho, \@profits, \@weights );
isa_ok( $knap,  "Algorithm::Evolutionary::Fitness::Knapsack" );

my $indi = random_bitstring $Nmax, 1 ; # Build random bitstring with length 10
ok( $knap->_apply( $indi ) > 0, "Works on indis" );
ok( $knap->knapsack( $indi->{'_str'})  > 0, "Works on strings and caches" );
ok( $knap->cached_evals() == 1, "Cached evals OK");

done_testing();
