#!/usr/bin/perl

package eBay::API::XML::DataType::AmountType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AmountType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AmountType

=head1 DESCRIPTION

Basic type for specifying monetary amounts. A double value (e.g.,
1.00 or 1.0) is meaningful as a monetary amount when accompanied by a
specification of the currency, in which case the value specifies
the amount in that currency. An AmountType expresses both the value
(a double) and the currency. Details such as prices, fees, costs,
and payments are specified as amount types.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AmountType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::CurrencyCodeType;


my @gaProperties = ( [ 'content', 'xs:double', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'currencyID', 'ns:CurrencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CurrencyCodeType', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setValue()

#    Argument: 'xs:double'

=cut

sub setValue {
  my $self = shift;
  $self->{'content'} = shift
}

=head2 getValue()

#    Returns: 'xs:double'

=cut

sub getValue {
  my $self = shift;
  return $self->{'content'};
}




=head2 setCurrencyID()

Currency in which the monetary amount is specified.<br>
<br>
In the AddItem family of calls, the currency can be specified in
the Item.Currency field instead. If you do specify this attribute
in the AddItem family of calls,
the value must match the site currency (i.e., it must be the same as the
value in Item.Currency) unless otherwise stated.

  Calls: AddOrder
  RequiredInput: Yes
  Context: Order.Total

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

  Calls: RespondToBestOffer
         ReviseCheckoutStatus
  RequiredInput: No

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  Returned: Always

  Calls: AddLiveAuctionItem
         ReviseLiveAuctionItem
  RequiredInput: No
  Returned: Always

  Calls: GetAllBidders
         GetStoreOptions
  RequiredInput: Yes
  Returned: Always

  Calls: RelistItem
  RequiredInput: No

  Calls: AddTransactionConfirmationItem
  RequiredInput: Yes

  Calls: SendInvoice
  RequiredInput: No
  ExcludeFromContext: ShippingInsuranceCost, ShippingServiceCost,
								ShippingServiceAdditionalCost, SalesTaxAmount, InsuranceFee
							

#    Argument: 'ns:CurrencyCodeType'

=cut

sub setCurrencyID {
  my $self = shift;
  $self->{'currencyID'} = shift
}

=head2 getCurrencyID()

  Calls: GetBidderList
         GetItemRecommendations
         GetItemShipping
         GetMyeBaySelling
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

  Calls:   Returned: Always
  ExcludeFromContext: InternationalShippingServiceOption
                      ShippingServiceOptions
                      ShippingServiceSelected


  Calls: GetBestOffers
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none
  ExcludeFromContext: InternationalShippingServiceOption
                      ShippingServiceOptions
                      ShippingServiceSelected


  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none
  Context: InternationalShippingServiceOption
           ShippingServiceOptions
           ShippingServiceSelected

  Calls: GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none
  Context: InternationalShippingServiceOption
           ShippingServiceOptions
           ShippingServiceSelected

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  Context: InternationalShippingServiceOption
           ShippingServiceOptions
           ShippingServiceSelected

  Calls: PlaceOffer
  Returned: Always
  Context: ConvertedCurrentPrice
           CurrentPrice

  Calls: PlaceOffer
  Returned: Conditionally
  Context: MinimumToBid

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  Returned: Always

  Calls: AddLiveAuctionItem
         ReviseLiveAuctionItem
  RequiredInput: No
  Returned: Always

  Calls: GetAllBidders
         GetStoreOptions
  RequiredInput: Yes
  Returned: Always

#    Returns: 'ns:CurrencyCodeType'

=cut

sub getCurrencyID {
  my $self = shift;
  return $self->{'currencyID'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
