# Generated by default/object.tt
package Paws::AmplifyBackend::CreateBackendAuthOAuthConfig;
  use Moose;
  has DomainPrefix => (is => 'ro', isa => 'Str', request_name => 'domainPrefix', traits => ['NameInRequest']);
  has OAuthGrantType => (is => 'ro', isa => 'Str', request_name => 'oAuthGrantType', traits => ['NameInRequest'], required => 1);
  has OAuthScopes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'oAuthScopes', traits => ['NameInRequest'], required => 1);
  has RedirectSignInURIs => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'redirectSignInURIs', traits => ['NameInRequest'], required => 1);
  has RedirectSignOutURIs => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'redirectSignOutURIs', traits => ['NameInRequest'], required => 1);
  has SocialProviderSettings => (is => 'ro', isa => 'Paws::AmplifyBackend::SocialProviderSettings', request_name => 'socialProviderSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::CreateBackendAuthOAuthConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::CreateBackendAuthOAuthConfig object:

  $service_obj->Method(Att1 => { DomainPrefix => $value, ..., SocialProviderSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::CreateBackendAuthOAuthConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainPrefix

=head1 DESCRIPTION

Creates the OAuth configuration for your Amplify project.

=head1 ATTRIBUTES


=head2 DomainPrefix => Str

The domain prefix for your Amplify app.


=head2 B<REQUIRED> OAuthGrantType => Str

The OAuth grant type that you use to allow app users to authenticate
from your Amplify app.


=head2 B<REQUIRED> OAuthScopes => ArrayRef[Str|Undef]

List of OAuth-related flows used to allow your app users to
authenticate from your Amplify app.


=head2 B<REQUIRED> RedirectSignInURIs => ArrayRef[Str|Undef]

The redirected URI for signing in to your Amplify app.


=head2 B<REQUIRED> RedirectSignOutURIs => ArrayRef[Str|Undef]

Redirect URLs used by OAuth when a user signs out of an Amplify app.


=head2 SocialProviderSettings => L<Paws::AmplifyBackend::SocialProviderSettings>

The settings for using social providers to access your Amplify app.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

