use Test2::V0 -no_srand => 1;
use Test::Clustericious::Cluster;

my $cluster = Test::Clustericious::Cluster->new;

is(
  intercept { $cluster->create_plugauth_lite_ok },
  array {
    event Ok => sub {
      call pass => T();
      call name => match qr{^PlugAuth::Lite instance on http://127.0.0.1:[0-9]+$};
    };
    end;
  },
  'create_plugauth_lite_ok'
);

my $t = $cluster->t;
$t->get_ok("@{[ $cluster->auth_url ]}/auth")
  ->status_is(401)
  ->content_is('please authenticate');

is(
  intercept { $cluster->create_plugauth_lite_ok },
  array {
    event Ok => sub {
      call pass => F();
      call name => match qr{^PlugAuth::Lite instance on http://127.0.0.1:[0-9]+$};
    };
    event Diag => sub {
      # generated by TB / T2
    };
    event Diag => sub {
      call message => 'only use create_plugauth_lite_ok once';
    };
    end;
  },
  'create_plugauth_lite_ok again',
);

done_testing;
