package WebService::MinFraud::Role::Model;

use Moo::Role;

our $VERSION = '0.002000';

use Types::Standard qw( HashRef );

has raw => (
    is       => 'ro',
    isa      => HashRef,
    required => 1,
);

around BUILDARGS => sub {
    my $orig = shift;
    my $self = shift;

    my $p = $self->$orig(@_);
    delete $p->{raw};

    # We make a copy to avoid a circular reference
    $p->{raw} = { %{$p} };

    return $p;
};

1;

# ABSTRACT: A role for storing there original response in the raw attribute

__END__

=pod

=head1 NAME

WebService::MinFraud::Role::Model - A role for storing there original response in the raw attribute

=head1 VERSION

version 0.002000

=head1 AUTHOR

Mateu Hunter <mhunter@maxmind.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 - 2016 by MaxMind, Inc..

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
