use Test::Simple 'no_plan';
use strict;
use lib './lib';
use Cwd;
use vars qw($_part $cwd $DEBUG);
use String::Similarity::Group;
use Time::HiRes 'time';
use LEOCHARRE::Dir 'lsf';

$DEBUG = 1;
$cwd = cwd();

my @lists_to_test = qw/listlongest.txt/;


my @methods_to_test = qw/_group_new/;
my @thresholds_to_test = qw/0.6/;

scalar @lists_to_test or die('no list txt files');

=pod

test all group methods, against all thresholds, and all lists

=cut


for my $infilename (@lists_to_test) {
   for my $method ( @methods_to_test ){
      for my $threshold ( @thresholds_to_test ){
         testone($infilename, $threshold, $method);
      }
   }
}


















sub ok_part {
   printf STDERR "\n\n===================\nPART %s %s\n==================\n\n",
      $_part++, "@_";
}




sub testone {
   my( $infilename, $threshold, $METHOD ) = @_;
   my $infile = "./t/$infilename";
   
   -f $infile or die("not on disk '$infile'");
   $threshold or die('missing threshold');
   $METHOD or die('missing method');
   ok_part("$METHOD $threshold $infile");

   
   # read in list file   
   open( FILE, '<', $infile ) or die $!;
   my @names = map { chomp $_; $_ } <FILE>;
   close FILE;

   my $c = scalar @names;
   ok($c, "got $c elements to group...") or exit;


   my $start = time();
   no strict 'refs';
   my @g = &{"String::Similarity::Group:\:$METHOD"}( $threshold, \@names);

   my $expired = (time() - $start);
   ok( @g,"got groups back");
   my $groups_made = scalar @g;
   ok( $groups_made > 1,"made mode than one group with method $METHOD");

   require Time::Format;
   
   my $summary = sprintf "generated by %s, %s
in          %s
elements    %s
threshold   %s
method      %s
groups      %s
seconds     %s

", $0, Time::Format::time_format('yy/mm/dd hh:mm',time()), 
   $infile, $c, $threshold, $METHOD, $groups_made, $expired;


   printf "SUMMARY:\n%s\n%s\n", $summary, '-'x60;
   

   
}






