/* Data.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

char rcsid[] = "$Id: labrea.c 2.4b3 2002/03/25 12:00:00 tliston Exp tliston $";
#ifdef OLDSTYLE
#ifdef WIN32
char HardExcludeName[] = "LaBreaHardExclude.cfg";
char HardExcludeNotFound[] = "LaBreaHardExclude.cfg not found - no hard exclusions";
char IgnoreName[] = "LaBreaIgnoreIP.cfg";
char IgnoreNotFound[] = "LaBreaIgnoreIP.cfg not found - nothing to ignore";
char ExcludeName[] = "LaBreaExclude.cfg";
char ExcludeNotFound[] = "LaBreaExclude.cfg not found - no hard exclusions";
char IgnorePortName[] = "LaBreaIgnorePort.cfg";
char IgnorePortNotFound[] = "LaBreaIgnorePort.cfg not found - nothing to ignore";
#else
char HardExcludeName[] = "/etc/LaBreaHardExclude";
char HardExcludeNotFound[] = "/etc/LaBreaHardExclude not found - no hard exclusions";
char IgnoreName[] = "/etc/LaBreaIgnoreIP";
char IgnoreNotFound[] = "/etc/LaBreaIgnoreIP not found - nothing to ignore";
char ExcludeName[] = "/etc/LaBreaExclude";
char ExcludeNotFound[] = "/etc/LaBreaExclude not found - no hard exclusions";
char IgnorePortName[] = "/etc/LaBreaIgnorePort";
char IgnorePortNotFound[] = "/etc/LaBreaIgnorePort not found - nothing to ignore";
#endif /* WIN32 */
char format3[] = "Exclude: %i.%i.%i.%i\n";
char format4[] = "HardExclude: %i.%i.%i.%i\n";
#else /* !OLDSTYLE */
#ifdef WIN32
char ConfigName[] = "LaBrea.cfg";
char ConfigNotFound[] = "LaBrea.cfg not found";
#else
char ConfigName[] = "/etc/LaBreaConfig";
char ConfigNotFound[] = "/etc/LaBreaConfig not found";
#endif /* WIN32 */
#endif /* OLDSTYLE */

char format1[] = "%li.%li.%li.%li";
char format2[] = "%s: %s %i -> %s %i";
char format5[] = "%s\n";
char format6[] = "%s: %i.%i.%i.%i";
char format7[] = "%s makes no sense: %s - Ignoring";
char format8[] = "%lu %s\n";
char format9[] = "%s %s\n";
char format10[] = "IP address not in netblock: ARP WHO-HAS %i.%i.%i.%i TELL %i.%i.%i.%i";
char format11[] = "%s: %i.%i.%i.%i\n";
char str1[]    = "%d/%d packets (received/dropped) by filter";
char str2[]    = "Re-initialized...";
char str3[]    = "Exiting...";
char str4[]    = "Note: EXCLUSIONS OVERRIDE HARDEXCLUSIONS\n";
char str5[]    = "HAR";
char str6[]    = "EXC";
char str7[]    = "IPI";
char str8[]    = "POR";
char str9[]    = "HardExclude IP";
char str10[]   = "Exclusion IP";
char str11[]   = "Ignore IP";
char str12[]   = "Ignore Port";
char str13[]   = "Configuration file - line with no specifier:\n%s\n";
char str14[]   = "Excluding resolvable IP addresses\n";
char str15[]   = "Ignoring Port: %i\n";
char str16[]   = "allocNKOTB: malloc error";
char str17[]   = "Capturing local IP";
char str18[]   = "IP address not in netblock - ARP-REPLY";
char str19[]   = "Received #%d signal, setting datalogging to on";
char str20[]   = "Received #%d signal, restartlog set datalog to %d";
char str21[]   = "Received #%d signal, stop log set datalog (%d) to off";
char str22[]   = " or (";
char str23[]   = ")";
char strstar[] = " *";
char strlf[]   = "\n";
char ignorestr[] = "Ignoring";
char rstring[] = "r";
char dashstr[] = "-";
char devnull[] = "/dev/null";
char msg1[]    = "Initial Connect (tarpitting)";
char msg2[]    = "Additional Activity";
char msg3[]    = "Persist Trapping";
char msg4[]    = "Persist Activity";
char msg4a[]   = "Linux Persist Activity";
char msg5[]    = "Inbound SYN/ACK";
char msg6[]    = "Responded to a PING: %s -> %s";
char bwstr[]   = "Current average bw: %i (bytes/sec)";
char lbwill[]  = "LaBrea will %s\n";
char diag1[]   = "attempt to capture unused IPs";
char diag2[]   = "NOT attempt to capture unused IPs";
char diag3[]   = "NOT warn when it sees ARPs from outside the netblock";
char diag4[]   = "log to syslog";
char diag5[]   = "log to stdout";
char diag6[]   = "log verbosely";
char diag7[]   = "\"hard capture\" IPs";
char diag8[]   = "attempt to operate safely in a switched environment";
char diag9[]   = "NOT answer SYN/ACKs or PINGS\n";
char diag10[]  = "LaBrea will capture connections in persist state up to %u bytes/second\n";
char diag11[]  = "Persist mode capture ONLY.\n";
char diag12[]  = "Interface to be used: %s\n";
char diag13[]  = "Initiated on interface ";
char diag14[]  = "automatically mark non-excluded addresses as being hard captured";
char bpf[]     = "arp or (ip and ether host 00:00:0F:FF:FF:FF)";
char err1[]    = "pcap_setfilter failed";
char err2[]    = "pcap_compile error";
char err3[]    = "pcap_open_live error";
#ifdef WIN32
char err4[]    = "You must specify the IP address with -I (i.e -I 10.10.2.1)";
char err5[]    = "You must specify the MAC address with -E (i.e. -E 11:22:33:44:55:66)";
char err6[]    = "You must specify the IP address with network mask (i.e -I 10.1.2.1/24)";
char err9[]    = "pcap_lookupdev error";
char err16[]   = "No interface specified with -i!";
char err17[]   = "Invalid or missing interface!";
char getoptstr[] = "HXPoOdTRqr:i:t:lvVxs?hzap:bE:I:Df";
#else
char err18[]   = "User specified netmask: %s\nUser specified network number: %s\n";
char getoptstr[] = "HXPoOdTRqF:r:i:t:lvVxsn:m:?hzap:bf";
#endif
char err7[]    = "malloc error: time_array - unable to allocate memory";
char err8[]    = "malloc error: exclusion - unable to allocate memory";
char err10[]   = "If you specify the netmask, you MUST also specify the network number (-n)";
char err11[]   = "If you specify the network number, you MUST also specify the netmask (-m)";
char err12[]   = "Command line filter and filter file specified - Ambiguous!";
char err13[]   = "malloc error: addr_array - unable to allocate memory";
char err14[]   = "Unable to open filter file";
char err15[]   = "You're missing the \"-z\" flag. See the docs.\n";
char err19[]   = "pcap_lookupdev: %s\n";
char err20[]   = "pcap_lookupnet(%s): %s\n";
char err21[]   = "libnet - unable to open link interface";
char err22[]   = "libnet - unable to get hardware address";
char err23[]   = "libnet - unable to get ip address";
char err24[]   = "Error in pcap loop - EXITING\n";
char err25[]   = "%s... Exiting.\n";
char err26[]   = "Error starting fork";
char test1[]   = "Network number: %i.%i.%i.%i\nNetmask: %i.%i.%i.%i\n"
                 "Number of addresses LaBrea will watch for ARPs: %u\n"
                 "Range: %i.%i.%i.%i - %i.%i.%i.%i\n"
                 "Full internal BPF filter: %s\nThrottle size set to WIN %i\nRate (-r) set to %i\n"
                 "Test mode run complete... LaBrea is exiting.\n";
char bigstring[] =
"Unsupported link layer!\n"
"Please contact the author, Tom Liston (tliston@hackbusters.net)\n"
"with link layer information so that support can be added.";
#ifdef USEZFLAG
char bigstring2[] =
"You MUST read the LaBrea.README file!  Don't try to run this\n"
"program without understanding how it works and what it can do!\n"
"In the LaBrea.README file, you'll find the command line switch\n"
"necessary to allow LaBrea to run.";
#endif
char helpstring[] =
"Usage: LaBrea <options> <BPF filter>\n"
"Options:\n"
#ifdef WIN32
"   -i interface : set interface, i.e. -i 1\n"
"   -D           : Lists available interfaces for -i\n"
"   -E           : MAC address of the interface (i.e. 00:2f:92:34:fe:01)\n"
"                  THIS NEEDS TO BE SUPPLIED IN THE WIN32 VERSION!\n"
"   -I           : Interface IP address with netmask (i.e. 10.1.0.1/24)\n"
"                  THIS NEEDS TO BE SUPPLIED IN THE WIN32 VERSION!\n"
#else
"   -i interface : Set a non-default interface\n"
#endif
"   -t datasize  : Set connection throttling size in bytes (default 10)\n"
"   -r rate      : Set arp timeout rate in seconds (default 3)\n"
"   -s           : \"Safe\" operation in a switched environment\n"
"   -l           : Log activity to syslog (Note 8)\n"
"   -v           : Verbosely log activity to syslog (Note 8)\n"
#ifndef WIN32
"   -F filename  : Specify a BPF filter filename (Note 2)\n"
#endif
"   -h           : \"Hard\" capture IPs (Note 4)\n"
"   -x           : Disable IP capture\n"
#ifndef WIN32
"   -m           : User specified netmask (Note 1)\n"
"   -n           : User specified network number (Note 1)\n"
#endif
"   -V           : Print version information and exit\n"
"   -a           : Do not respond to SYN/ACKs and PINGs (Note 6)\n"
"   -q           : Do not report odd (out of netblock) ARPs\n"
"   -T           : Test mode - Prints out debug info but DOES NOT RUN\n"
"   -R           : Soft restart - Wait while recapturing active connects\n"
"   -p maxrate   : \"Persist\" state capture connect attempts (Note 7)\n"
"   -b           : Log bandwidth usage to syslog\n"
"   -d           : Do NOT detach process.\n"
"   -o           : Output to stdout instead of syslog (Note 9)\n"
"   -O           : Same as -o w/time output in seconds since epoch\n"
"   -P           : Persist mode capture only.\n"
"   -X           : Automatically exclude resolvable IPs from capture.\n"
"   -H           : Automatically hard capture addresses not excluded.\n"
"   -f           : \"Firewall\" excluded ports.\n"
#ifndef WIN32
"Note 1:\n"
" The network number and netmask are normally loaded from the interface.\n"
" If you're using an interface that has no IP, you'll have to provide BOTH of\n"
" these numbers.  These MUST be correct or BAD things may happen!\n"
"Note 2:\n"
" Connections specified by the BPF filter will also be tarpitted.  These\n"
" connections MUST be firewalled to DROP inbound packets or this won't work!\n"
#endif
"Note 3:\n"
" \"Excluded\" IPs are those that you DON'T want LaBrea to ever capture.  You don't\n"
" need to specify \"active\" IPs.  LaBrea won't capture an IP with a machine\n"
" on it. This is only for empty IPs that you DON'T want captured.\n"
"Note 4:\n"
" \"HardExcluded\" IPs are those that you don't want LaBrea to hard capture.\n"
" This is only necessary with the -h option.\n"
"Note 5:\n"
" IPs can be specified as either a single address (i.e.: \"192.168.0.4\") or as a\n"
" range of addresses (i.e.: \"192.168.0.1 - 192.168.0.50\")\n"
"Note 6:\n"
" By default, LaBrea \"virtual machines\" respond to an inbound SYN/ACK with a\n"
" RST and are \"pingable\".  The -a option eliminates this behavior.\n"
"Note 7:\n"
" LaBrea will permanently capture connect attempts within the limit of the\n"
" maximum data rate specified (in bytes/sec).\n"
"Note 8:\n"
" With version 2.0.1+ you can use 'kill -USR1 <LaBrea_PID>' to toggle logging\n"
"  If logging was not enabled at start this sets the '-l' flag\n"
"  If logging (-l | -v) are set this saves the value and turns off logging\n"
"  If logging is presently toggled off it restores the saved level (-l | -v)\n"
"Note 9:\n"
" This sends log information to stdout rather than to syslog.  This option\n"
" also implies and sets the -d option (Do NOT detach process).\n";

