# Generated by default/object.tt
package Paws::CodeStarConnections::Host;
  use Moose;
  has HostArn => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has ProviderEndpoint => (is => 'ro', isa => 'Str');
  has ProviderType => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');
  has VpcConfiguration => (is => 'ro', isa => 'Paws::CodeStarConnections::VpcConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeStarConnections::Host

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeStarConnections::Host object:

  $service_obj->Method(Att1 => { HostArn => $value, ..., VpcConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeStarConnections::Host object:

  $result = $service_obj->Method(...);
  $result->Att1->HostArn

=head1 DESCRIPTION

A resource that represents the infrastructure where a third-party
provider is installed. The host is used when you create connections to
an installed third-party provider type, such as GitHub Enterprise
Server. You create one host for all connections to that provider.

A host created through the CLI or the SDK is in `PENDING` status by
default. You can make its status `AVAILABLE` by setting up the host in
the console.

=head1 ATTRIBUTES


=head2 HostArn => Str

The Amazon Resource Name (ARN) of the host.


=head2 Name => Str

The name of the host.


=head2 ProviderEndpoint => Str

The endpoint of the infrastructure where your provider type is
installed.


=head2 ProviderType => Str

The name of the installed provider to be associated with your
connection. The host resource represents the infrastructure where your
provider type is installed. The valid provider type is GitHub
Enterprise Server.


=head2 Status => Str

The status of the host, such as PENDING, AVAILABLE,
VPC_CONFIG_DELETING, VPC_CONFIG_INITIALIZING, and
VPC_CONFIG_FAILED_INITIALIZATION.


=head2 StatusMessage => Str

The status description for the host.


=head2 VpcConfiguration => L<Paws::CodeStarConnections::VpcConfiguration>

The VPC configuration provisioned for the host.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeStarConnections>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

