# Generated by default/object.tt
package Paws::XRay::ForecastStatistics;
  use Moose;
  has FaultCountHigh => (is => 'ro', isa => 'Int');
  has FaultCountLow => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::XRay::ForecastStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::XRay::ForecastStatistics object:

  $service_obj->Method(Att1 => { FaultCountHigh => $value, ..., FaultCountLow => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::XRay::ForecastStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->FaultCountHigh

=head1 DESCRIPTION

The predicted high and low fault count. This is used to determine if a
service has become anomalous and if an insight should be created.

=head1 ATTRIBUTES


=head2 FaultCountHigh => Int

The upper limit of fault counts for a service.


=head2 FaultCountLow => Int

The lower limit of fault counts for a service.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::XRay>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

