use strict;
use warnings;
use lib './t';
use Test::More tests => 2;

use DBI;
use Mock::SQLite;

BEGIN {
    my $dbh = DBI->connect('dbi:SQLite:test.db', '', '');
    Mock::SQLite->dbh($dbh);
    Mock::SQLite->setup_test_db;
}
END { Mock::SQLite->clean_test_db }

use DBIx::Skinny::Schema::Loader qw/make_schema_at/;

my $before = '# custom template';
my $tmpl = 'install_utf8_columns qw/jpname title content/;';

my $after = << '...';
my $created_at = sub {
    my ($class, $args) = @_;
    $args->{ created_at } ||= DateTime->now;
};
...

my $table_template = << '...';
install_table [% table %] => schema {
    pk qw/[% pk %]/;
    columns qw/[% columns %]/;
    trigger pre_insert => $created_at;
};

...

ok my $schema = make_schema_at(
    'Mock::DB::Schema',
    {
        table_template  => $table_template,
        template        => $tmpl, # deplicated, use before_template
        before_template => $before,
        after_template  => $after,
    },
    [ 'dbi:SQLite:test.db', '', '' ]
), 'got schema class file content by make_schema_at';

is "$schema\n", << "...", 'assert content';
# THIS FILE IS AUTOGENERATED BY DBIx::Skinny::Schema::Loader ${DBIx::Skinny::Schema::Loader::VERSION}, DO NOT EDIT DIRECTLY.

package Mock::DB::Schema;
use DBIx::Skinny::Schema;

# ---- beginning of custom template ----
# custom template
# ---- end of custom template ----

# ---- beginning of custom template ----
install_utf8_columns qw/jpname title content/;
# ---- end of custom template ----

install_table authors => schema {
    pk qw/id/;
    columns qw/id gender_name pref_name name/;
    trigger pre_insert => \$created_at;
};

install_table books => schema {
    pk qw/id/;
    columns qw/id author_id name/;
    trigger pre_insert => \$created_at;
};

install_table composite => schema {
    pk qw/id name/;
    columns qw/id name/;
    trigger pre_insert => \$created_at;
};

install_table genders => schema {
    pk qw/name/;
    columns qw/name/;
    trigger pre_insert => \$created_at;
};

install_table no_pk => schema {
    pk qw//;
    columns qw/code name/;
    trigger pre_insert => \$created_at;
};

install_table prefectures => schema {
    pk qw/name/;
    columns qw/id name/;
    trigger pre_insert => \$created_at;
};

# ---- beginning of custom template ----
my \$created_at = sub {
    my (\$class, \$args) = \@_;
    \$args->{ created_at } ||= DateTime->now;
};
# ---- end of custom template ----

1;
...
