package Daje::Helper::Login;
use Mojo::Base 'Mojolicious::Plugin', -async_await;
use v5.40;

# NAME
# ====
#
# Daje::Helper::Login - Its a
#
#
# DESCRIPTION
# ===========
#
# my $json = encode_json($login);
#
#
# REQUIRES
# ========
#
# Daje::Database::Model::Login
#
# Daje::Tools::JWT
#
# v5.40
#
# Mojo::Base
#
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Data::Dumper;
use Daje::Tools::JWT;
use Daje::Database::Model::Login;
use Digest::SHA qw{sha512_base64};

our $VERSION = "0.01";

has 'pg';

async sub login_user ($self, $userid, $password) {

    $password = sha512_base64 $password;

    say "Password: " . Dumper($password);
    my $login = Daje::Database::Model::Login->new(
        pg => $self->pg
    )->login(
        $userid, $password
    );

    my $jwt;
    my $result;

    if($login) {
        #my $json = encode_json($login);
        $jwt = await Daje::Tools::JWT->new()->encode_jwt_p(
            $login
        );

        $result = {
            userid   => $userid,
            jwt      => $jwt,
            expires  => '',
            support => $login->{support}
        };
    }

    return $result;
}
1;

#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Helper::Login - Its a




=head1 DESCRIPTION


my $json = encode_json($login);




=head1 REQUIRES


Daje::Database::Model::Login

Daje::Tools::JWT

v5.40

Mojo::Base




=head1 METHODS





=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

