/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.IOException;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.util.HexDump;

public final class HSSFObjectData {
    private final ObjRecord _record;
    private final DirectoryEntry _root;

    public HSSFObjectData(ObjRecord record, DirectoryEntry root) {
        this._record = record;
        this._root = root;
    }

    public String getOLE2ClassName() {
        return this.findObjectRecord().getOLEClassName();
    }

    public DirectoryEntry getDirectory() throws IOException {
        EmbeddedObjectRefSubRecord subRecord = this.findObjectRecord();
        int streamId = subRecord.getStreamId();
        String streamName = "MBD" + HexDump.toHex(streamId);
        Entry entry = this._root.getEntry(streamName);
        if (entry instanceof DirectoryEntry) {
            return (DirectoryEntry)entry;
        }
        throw new IOException("Stream " + streamName + " was not an OLE2 directory");
    }

    public byte[] getObjectData() {
        return this.findObjectRecord().getObjectData();
    }

    public boolean hasDirectoryEntry() {
        EmbeddedObjectRefSubRecord subRecord = this.findObjectRecord();
        Integer streamId = subRecord.getStreamId();
        return streamId != null && streamId != 0;
    }

    protected EmbeddedObjectRefSubRecord findObjectRecord() {
        for (SubRecord subRecord : this._record.getSubRecords()) {
            if (!(subRecord instanceof EmbeddedObjectRefSubRecord)) continue;
            return (EmbeddedObjectRefSubRecord)subRecord;
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }
}

