use strict;
use warnings;
use Test::More;

if ( -e '.git' ) {
    plan skip_all => 'in repo';
}
elsif ( $ENV{UUID_DISTTEST} ) {
    plan tests => 10;
}
else {
    plan skip_all => 'in release';
}

ok -e 'License',   'License exists';
ok -e 'META.json', 'META.json exists';
ok -e 'META.yml',  'META.yml exists';
ok -e 'README',    'README exists';

ok -s 'License',   'License not empty';
ok -s 'META.json', 'META.json not empty';
ok -s 'META.yml',  'META.yml not empty';
ok -s 'README',    'README not empty';

ok test_dynamic('META.json'), 'META.json authoritative';
ok test_dynamic('META.yml'),  'META.yml authoritative';

sub test_dynamic {
    my $f = shift;
    open my $fh, '<', $f or die "open: $!";
    while (<$fh>) {
        return 1 if m/dynamic_config.*?0/;
    }
    return 0;
}

exit 0;

